#include "testApp.h"
#include "stdio.h"

//--------------------------------------------------------------
testApp::testApp(){


    screenW = ofGetWidth();
    screenH = ofGetHeight();
    bShowFrameRate = false;
	
	mode = MODE_PLAYER;
	bHomeOn = true;
	
	capturingString = false;
	//capturedString = "";

}

testApp::~testApp(){


}
//--------------------------------------------------------------
void testApp::setup(){


    sW              = 1024;
	sH              = 768;

	//-----------
	lastX           = 0;
	lastY           = 0;
	mouse_mode      = 3;
	bShiftOn        = false;
	bMouseOn		= true;

    //-----------
    ofSetFrameRate(30);
    ofBackground(0.0f, 0.0f, 0.0f);
    ofSetVerticalSync(true);
		
	//-----------
	appGrafPlayer.setup();
	appGrafStart.setup();
	

}

//--------------------------------------------------------------
void testApp::update(){

    screenW = ofGetWidth();
    screenH = ofGetHeight();

	appGrafPlayer.update();
	appGrafStart.update(appGrafPlayer.dt);
	
	if(appGrafPlayer.mode == PLAY_MODE_PLAY) appGrafStart.bAllLoaded = true;
	if( appGrafStart.waitCounter <= 0 ) bHomeOn = false;
	if(!bHomeOn && appGrafPlayer.mode == PLAY_MODE_PLAY) appGrafStart.bOn = false;
	
}


//--------------------------------------------------------------
void testApp::draw(){


	appGrafPlayer.draw();
	appGrafStart.draw( appGrafPlayer.getCurrentTagName(), appGrafPlayer.myTagDirectory );
	
	//ofDrawBitmapString( ofToString( ofGetFrameRate(), 2), 20, 20);

}


//--------------------------------------------------------------
void testApp::keyPressed  (int key){
	
	//if( bHomeOn ) bHomeOn = false;
	
	if (key == OF_KEY_RETURN)
	{
		if (capturingString == false) {
			capturingString = true;
			capturedString.str( "" );
			std::cout << "starting log word" << std::endl;
		} else {
			std::cout << "ending log word: " << capturedString.str() << std::endl;
			capturingString = false;
			
			//todo: show loading message on gui and/or multithread this call. just to avoid things grinding to a hault while we load..
			
			appGrafPlayer.loadTagsFromRSS(capturedString.str().c_str());
		}
	}
	
	if (capturingString == false) {	
		appGrafPlayer.keyPressed(key);
		if( key == 'm')
		{
			if(bMouseOn){
				ofHideCursor();
				bMouseOn = false;
			}
			else{
				ofShowCursor();
				bMouseOn = true;
			}
		}
		if( key == 'f' ) ofToggleFullscreen();
		if( key == 'h' )
		{
			bHomeOn = !bHomeOn;
			appGrafStart.bOn = bHomeOn;
		}	
	} else {
		//dont capture arrows and return
		switch(key) {
			case OF_KEY_RETURN:
			case OF_KEY_LEFT:
			case OF_KEY_UP:
			case OF_KEY_RIGHT:
			case OF_KEY_DOWN: return;
		}
		
		//todo: there are probably some other things you're not supposed to capture.. filter/validate things here
		
		capturedString << (char)key;
	}
}

//--------------------------------------------------------------
void testApp::keyReleased(int key){

	appGrafPlayer.keyReleased(key);
}

//--------------------------------------------------------------
void testApp::mouseMoved(int x, int y ){

	appGrafPlayer.mouseMoved(x,y);
}

//--------------------------------------------------------------
void testApp::mouseDragged(int x, int y, int button){


	appGrafPlayer.mouseDragged(x,y,button);


}

//--------------------------------------------------------------
void testApp::mousePressed(int x, int y, int button){

    appGrafPlayer.mousePressed(x,y,button);

	if(glutGetModifiers() == GLUT_ACTIVE_SHIFT) bShiftOn = true;
	else bShiftOn = false;
	
	appGrafPlayer.bShiftOn = bShiftOn;


}

//--------------------------------------------------------------
void testApp::mouseReleased(int x, int y, int button){

    appGrafPlayer.mouseReleased(x,y,button);
	
	bShiftOn = false;


}

//--------------------------------------------------------------
void testApp::resized(int w, int h){

}


