#include "bparticle.h"
#include "ofMain.h"
#define OF_ADDON_USING_OFXVECTORMATH
#include "ofAddons.h"

//------------------------------------------------------------
bparticle::bparticle(){
	setInitialCondition(0,0,0,0);
	damping = 0.05f;
}

//------------------------------------------------------------
void bparticle::resetForce(){
    // we reset the forces every frame
    frc.set(0,0,0);
}

//------------------------------------------------------------
void bparticle::addForce(float x, float y, float z){
    // add in a force in X and Y for this frame.
    frc.x = frc.x + x;
    frc.y = frc.y + y;
    frc.z = frc.z + z;
}

//------------------------------------------------------------
void bparticle::addDampingForce(){

	// the usual way to write this is  vel *= 0.99
	// basically, subtract some part of the velocity
	// damping is a force operating in the oposite direction of the
	// velocity vector

    frc.x = frc.x - vel.x * damping;
    frc.y = frc.y - vel.y * damping;
	frc.z = frc.z - vel.z * damping;
}

//------------------------------------------------------------
void bparticle::setInitialCondition(float px, float py, float vx, float vy){
    pos.set(px,py,0);
	vel.set(vx,vy,0);
}

//------------------------------------------------------------
void bparticle::setInitialCondition(float px, float py, float pz, float vx, float vy, float vz){
    pos.set(px,py,pz);
	vel.set(vx,vy,vz);
}

//------------------------------------------------------------
void bparticle::update(){
	vel = vel + frc;
	pos = pos + vel;
}

//------------------------------------------------------------
void bparticle::draw(){
	glPushMatrix();
	glTranslatef(pos.x, pos.y,pos.z);
    ofCircle(0,0, 1);
	glPopMatrix();
}

