#include "particle.h"


particle::particle(){
		ox = 0;
		oy = 0;
		px = 0;
		py = 0;
		pz = 0;
		vx = 0;
		vy = 0;
		bAlive = false;
		dropOffRate = 0.75f;
		counter = 0;

		bRecvVFptr = false; // havent got ptr yet
}

void particle::reset(){
	ox = 0;
	oy = 0;
	px = 0;
	py = 0;
	pz = 0;
	vx = 0;
	vy = 0;
	bAlive = false;
	dropOffRate = 0.75f;
	counter = 0;

	bRecvVFptr = false;
}



void particle::setPropertiesAndTurnOn(float x,float y,float x_v,float y_v, float z){
	ox = x;
	oy = y;
	px = x;
	py = y;
	pz = z;
	vx = x_v;
	vy = y_v;
	bAlive = true;		//this will tell draw() to draw it

}

void particle::update(){
	//add veloctiy into particle position
	px += vx;
	py += vy;

	//checks for screen wrapping
	//if (px < 0) px = 1024;
	//if (px > 1024) px = 0;
	//if (py < 0) py = 768;
	//if (py > 768) py = 0;

	//look up VF prosition and return values
	//float * addToV = VFptr->getVfromPos(px/1024.0f, py/768.0f);
    float addVX = VFptr->getXVel(px/1024.0f, py/768.0f);
    float addVY = VFptr->getYVel(px/1024.0f, py/768.0f);
	//printf("addto %f %f\n",addToV[0],addToV[1]);

	vx += addVX;
	vy += addVY;

	vx *= dropOffRate;
	vy *= dropOffRate;



}

void particle::draw(float time){

	float size = 1.5;

	if(px > 0 && py > 0 && ox != px && oy != py){

		if (bAlive == true){

			if(counter == 0){
				pz = time;
			}
			counter++;

			glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
			glEnable(GL_BLEND);
			glColor4f(.6,.6,.6,.2);
            //glColor4f(.6,.6,.6,1);



			//draw lines
			//glColor3f(0.67,0.67,0.67);
			glBegin(GL_LINES);
			//glEnable(GL_BLEND);
			//glBlendFunc(.5, .5);
				glVertex3f(ox, oy, pz);
				glVertex3f(px, py, pz);

			glEnd();

			glDisable(GL_BLEND);

			//draw points
			glColor3f(1,1,1);
			glBegin(GL_QUADS);
				glVertex3f(px-size,py-size, pz);
				glVertex3f(px-size,py+size, pz);
				glVertex3f(px+size,py+size, pz);
				glVertex3f(px+size,py-size, pz);
			glEnd();

		}
	}
}
