#include "particleSystem.h"

particleSystem::particleSystem()
{
    //ctor
}

particleSystem::~particleSystem()
{

}

void particleSystem::clear()
{
    PTS.clear();
}

void particleSystem::reset(int w, int h)
{
    for (int i = 0; i < PTS.size()-1; i++)
    {
			PTS[i].reset();
    }

    if( w*h > PTS.size() ) return;

    float scalex = ofGetWidth()  / (float)w;
	float scaley = ofGetHeight() / (float)h;

	for (int i = 0; i < w; i++)
	{

		for (int j = 0; j < h; j++)
		{
			int pos = j * w + i;
			PTS[pos].setPropertiesAndTurnOn(i*scalex,j*scaley,0,0,0);
		}
	}
}


void particleSystem::setup(int fieldsize, int w, int h, vectorField * VF)
{
    particle p;

    for (int i = 0; i < fieldsize; i++)
    {
        PTS.push_back(p);
        PTS[i].VFptr = VF;
    }

	reset(w,h);


}

void particleSystem::update(float time)
{
    for (int i = 0; i < PTS.size()-1; i++)  PTS[i].update();

}

void particleSystem::draw(float time)
{
    for (int i = 0; i < PTS.size()-1; i++)
    {
        PTS[i].draw( time );
    }
}
