#include "grafEditor.h"

grafEditor::grafEditor()
{
    grafName = "";
    lastName = "";
    bEditName = false;
    nameCounter = 0;
}

grafEditor::~grafEditor()
{
    //dtor
}

void grafEditor::setup(int x_, int y_, int w_, int h_)
{
    x = x_;
    y = y_;
    w = w_;
    h = h_;

    slider_end.setup( "start",0,0,1,x,y,w,h);
    slider_start.setup( "end",0,0,1,x,y,w,h);

    button_name.setup( x+500, y, 200, 18, true );
}

bool grafEditor::update(int mx, int my)
{
    if( button_name.update(mx,my) )
    {
        bEditName = true;
        return false;
    }else{
        bEditName = false;
    }


    bool bChanged = false;

    if( slider_end.hitTest(mx,my) )
    {
        cout << "hit slider" << endl;
        bChanged = true;

        int startX    = (int)(x + slider_start.getPctValue()*w);
        int endX      = (int)(x + slider_end.getPctValue()*w);


        if( abs(mx-startX) < abs(mx-endX) )
        {
            //if( startX+(mx-x) < endX )
                slider_start.update(mx,my);
        }else{
            //if( endX+(mx-x) > startX )
                slider_end.update(mx,my);
        }


    }

    return bChanged;

}

void grafEditor::updateMax( int max )
{
    slider_start.setup( "start",0,0,max,x,y,w,h);
    slider_end.setup( "end",max-1,0,max,x,y,w,h);
}

void grafEditor::draw()
{
    ofSetColor(255,255,255,255);
    ofNoFill();
    ofRect(x,y,w,h);

    // start pt
    ofSetColor(255,0,0);
    ofCircle( x + slider_start.getPctValue()*w, y+h/2, 2);
    ofSetColor(255,255,255,255);
    ofCircle( x + slider_end.getPctValue()*w, y+h/2, 2);

    if(bEditName )  ofSetColor(255,0,0);
    else            ofSetColor(255,255,255,255);


    ofNoFill();
    button_name.draw();

    ofSetColor(200,200,200,255);
    ofDrawBitmapString("Graf Name: ", button_name.getX()-90, button_name.getY()+14);

    ofSetColor(255,255,255,255);
    if(grafName.size() > 0) ofDrawBitmapString( grafName, button_name.getX()+3, button_name.getY()+14);

}

int grafEditor::getStart()
{
    return slider_start.getIntValue();
}


int grafEditor::getEnd()
{
    float sEnd = slider_end.getFloatValue();
    return (ceil)(sEnd);
}

void grafEditor::editName( char key )
{
    cout << (int) key << endl;
    if( grafName == "" ) grafName.clear();

    if(  grafName.size() > 0 && (key == OF_KEY_DEL || key == OF_KEY_BACKSPACE)  ){

         //if( grafName.size()== 1 ) grafName.clear();
         grafName.erase(grafName.size()-1);
    }
    else if( (int)key > 32 && (int)key < 126 && grafName.size() < 35 ) grafName.push_back(key);
}

string grafEditor::getName()
{


    if( grafName.size() == 0 ) return " ";
    if( nameCounter > 0 )  return grafName + "_" + ofToString(nameCounter);
    else return grafName;

}

void  grafEditor::checkNameForSaving()
{
    if( grafName == "" )
    {
        grafName.clear();
        grafName += ofToString(nameCounter);//.append("graf_"+ofToString( ofGetYear() )+ "_" + ofToString( ofGetMonth() ) + "_" + ofToString( ofGetDay() ) + "_"+ ofToString( ofGetHours() ) + "_" + ofToString( ofGetMinutes() ) + "_" + ofToString( ofGetSeconds() ) );
        nameCounter++;
    }

    if( PL.existsDirectory("data/tags",grafName) ){


        cout << "exists!" << endl;
        //if( nameCounter > 0 ) grafName.erase( grafName.end() - 2, grafName.end() );
        //grafName += "_" + ofToString(nameCounter);
        nameCounter++;
    }else
        nameCounter = 0;


    lastName = grafName;
}
