#ifndef POINT_RECORDER_H
#define POINT_RECORDER_H

#include "ofMain.h"


typedef struct {

	ofPoint		pos;
	float		time;

} timePt;



class pointRecorder {

	public:

        pointRecorder();

		virtual void addPoint(ofPoint pt);
		virtual void clear();
		virtual void draw();
		float getDuration();

		ofPoint getPointForTime(float time);
		ofPoint getVelocityForTime(float time);

		float				startTime;
		int					maxNumPts;
		vector <timePt>		pts;

		bool				bAmRecording;

};

#endif // POINT_RECORDER_H
