#include "guiManager.h"

guiManager::guiManager()
{
    //ctor
}

guiManager::~guiManager()
{
    //dtor
}

void guiManager::draw()
{
    for( int i = 0 ; i < sliders.size(); i++)
        sliders[i].draw();

    for( int i = 0; i < buttons.size(); i++)
        buttons[i].draw();
}


void guiManager::addSlider( string name, float defVal, float min, float max, float x, float y, float w, float h)
{
    guiSlider sliderNew;
    sliders.push_back(sliderNew);
    sliders[ sliders.size()-1 ].setup(name,defVal,min,max,x,y,w,h);
}

void guiManager::addButton( string name, float x, float y, float w, float h, bool bOnOff)
{
    guiButton newButton;
    buttons.push_back(newButton);
    buttons[ buttons.size()-1 ].setup( name, x,y,w,h,bOnOff);
}


bool guiManager::updateDrag( float mx, float my )
{
    for( int i = 0 ; i < sliders.size(); i++)
    {
        if( sliders[i].update(mx,my) ){
            saveDataToXML();
            return true;
        }
    }


}

bool guiManager::updatePress( float mx, float my )
{

    for( int i = 0; i < buttons.size(); i++)
    {
         if( buttons[i].update(mx,my) )
         {
             saveDataToXML();
             return true;
         }
    }

     return false;
}


float guiManager::getFloatVal( string name )
{
    for( int i = 0 ; i < sliders.size(); i++)
    {
        if( sliders[i].getName() == name ) return sliders[i].getFloatValue();
    }
    return 0;
}

int guiManager::getIntVal( string name )
{
    for( int i = 0 ; i < sliders.size(); i++)
    {
        if( sliders[i].getName() == name ) return sliders[i].getIntValue();
    }

    return 0;
}

float guiManager::getPctVal( string name )
{
   for( int i = 0 ; i < sliders.size(); i++)
    {
        if( sliders[i].getName() == name ) return sliders[i].getPctValue();
    }

    return 0;
}

bool guiManager::getButtonVal( string name )
{
    for( int i = 0 ; i < buttons.size(); i++)
    {
        if( buttons[i].name == name ) return buttons[i].bOn;
    }

    return false;
}

void guiManager::saveDataToXML()
{
	ofxXmlSettings xml;
	for( int i = 0 ; i < sliders.size(); i++)
    {
        string name = sliders[i].getName();
        int index = name.find_first_of(" ");
        while( (index=name.find_first_of(" ") ) > 0 )
        {
            name.erase(name.begin()+index);
        }

        xml.setValue(name,sliders[i].getFloatValue(),0.f );

    }

    for( int i = 0 ; i < buttons.size(); i++)
    {
        string name = buttons[i].name;
        int index = name.find_first_of(" ");
        while( (index=name.find_first_of(" ") ) > 0 )
        {
            name.erase(name.begin()+index);
        }

        xml.setValue(name,buttons[i].bOn,false );

    }

   xml.saveFile("settings/gui.xml");


}

void guiManager::loadDataFromXML()
{
	ofxXmlSettings xml;
	xml.loadFile("settings/gui.xml");

	for( int i = 0 ; i < sliders.size(); i++)
    {
        string name = sliders[i].getName();
        int index = name.find_first_of(" ");
        while( (index=name.find_first_of(" ") ) > 0 )
        {
            name.erase(name.begin()+index);
        }

        sliders[i].setValue( xml.getValue(name,0.f ) );

    }

    for( int i = 0 ; i < buttons.size(); i++)
    {
        string name = buttons[i].name;
        int index = name.find_first_of(" ");
        while( (index=name.find_first_of(" ") ) > 0 )
        {
            name.erase(name.begin()+index);
        }

        buttons[i].bOn =  xml.getValue(name,false );

    }

   xml.saveFile("settings/gui.xml");


}
