#include "particle.h"


particle::particle(){

		ox = 0;
		oy = 0;
		px = 0;
		py = 0;
		pz = 0;
		vx = 0;
		vy = 0;

		bAlive      = false;
		bRecvVFptr  = false;

		dropOffRate = 0.25f;
		counter     = 0;
        force       = 1;
        size = 1.5;


}

void particle::reset(){

	ox = 0;
	oy = 0;
	px = 0;
	py = 0;
	pz = 0;
	vx = 0;
	vy = 0;

	bAlive      = false;
	bRecvVFptr  = false;
	//dropOffRate = .25f;
	counter     = 0;

}



void particle::setPropertiesAndTurnOn(float x,float y,float x_v,float y_v, float z){
	ox = x;
	oy = y;
	px = x;
	py = y;
	pz = z;
	vx = x_v;
	vy = y_v;
	bAlive = true;		//this will tell draw() to draw it

}

void particle::update(float screenW, float screenH, float dt){


	//add veloctiy into particle position
	px += vx*dt;
	py += vy*dt;

	//look up VF prosition and return values
    ofPoint addV = VFptr->getVel(px/screenW, py/screenH);
    float addVX = dt*(force*addV.x);
    float addVY = dt*(force*addV.y);

	vx += addVX;
	vy += addVY;

	vx -= vx*(dropOffRate*dt);
	vy -= vy*(dropOffRate*dt);


}

void particle::updateVel(float dt, float damping)
{
	//add veloctiy into particle position
	px += vx*dt;
	py += vy*dt;

	//vx -= vx*(damping*dt);
	//vy -= vy*(damping*dt);
}


void particle::draw(float time){


}
