#include "grafEditor.h"

grafEditor::grafEditor()
{

}

grafEditor::~grafEditor()
{
    //dtor
}

void grafEditor::setup(int x_, int y_, int w_, int h_)
{
    x = x_;
    y = y_;
    w = w_;
    h = h_;

    slider_end.setup( "start",0,0,1,x,y,w,h);
    slider_start.setup( "end",0,0,1,x,y,w,h);
}

bool grafEditor::update(int mx, int my)
{
    bool bChanged = false;

    if( slider_end.hitTest(mx,my) )
    {
        cout << "hit slider" << endl;
        bChanged = true;

        int startX    = (int)(x + slider_start.getPctValue()*w);
        int endX      = (int)(x + slider_end.getPctValue()*w);


        if( abs(mx-startX) < abs(mx-endX) )
        {
            //if( startX+(mx-x) < endX )
                slider_start.update(mx,my);
        }else{
            //if( endX+(mx-x) > startX )
                slider_end.update(mx,my);
        }


    }

    return bChanged;

}

void grafEditor::updateMax( int max )
{
    slider_start.setup( "start",0,0,max,x,y,w,h);
    slider_end.setup( "end",max-1,0,max,x,y,w,h);
}

void grafEditor::draw()
{
    ofSetColor(255,255,255,255);
    ofNoFill();
    ofRect(x,y,w,h);

    // start pt
    ofSetColor(255,0,0);
    ofCircle( x + slider_start.getPctValue()*w, y+h/2, 2);
    ofSetColor(255,255,255,255);
    ofCircle( x + slider_end.getPctValue()*w, y+h/2, 2);

}

int grafEditor::getStart()
{
    return slider_start.getIntValue();
}


int grafEditor::getEnd()
{
    return slider_end.getIntValue();
}
