#ifndef GRAFPARTICLEVECFIELD_H
#define GRAFPARTICLEVECFIELD_H

#include "vectorField.h"
#include "particleSystem.h"
#include "grafTag.h"

class grafParticleVecField
{
    public:
        grafParticleVecField();
        virtual ~grafParticleVecField();

        void setup(int w, int h);
        void reset();

        void update( grafTag * PR,ofPoint pointForTime, ofPoint vel, float dt, bool bUpdateVF=true);
        void retractParticles(float dt, float cx = 512, float cy = 384);
        void transitionUp(float dt, particleSystem * pst);
        void transitionDown(float dt, particleSystem * pst);
        void transitionUpAndDown(float dt, particleSystem * pst);
        void transitionFireWorks(float dt, particleSystem * pst, float cx = 512, float cy = 384);

        void setDamping( float val );
        void setParticleSize( float val );


        //void draw( float z );
        void draw( grafTag * PR, int screenW, int screenH );



        int w, h;
        float alpha;
        int mode;

        float particle_damping;
        float particle_size;
        float particle_alpha;



    protected:




        // particles with attached lines
        particleSystem  PS;

        // solo particles
        vector<particleSystem> XTRA_PS;

		// normal vector field
		vectorField     VF;




		int transitionCounter;

    private:
};

#endif // GRAFPARTICLEVECFIELD_H
