#ifndef GRAFVIZSTROKED_H
#define GRAFVIZSTROKED_H

#include "grafTag.h"

class grafVizStroked
{
    public:
        grafVizStroked();
        virtual ~grafVizStroked();

        void reset();


        void draw( grafTag * PR );
        void drawArrow( grafTag * PR );
        void drawWireframe( grafTag * PR );
        void drawTimeStroked( grafTag * PR );
        void drawTimeLine( grafTag * PR );

        void alterParam( float val, float & param );
        void averagePoints(float pct);

        float alphaWireFrame;
        float alphaArrow;
        float alphaStroke;
        float alphaStrokeOutline;
        float fadeLineWidth;

        float strokeBaseAlpha;
        float strokeBaseVal;
        float outlineBaseVal;
        float outlineBaseThick;
        float sclLineSlim;
        float sclLineFat;
        bool bUseSlimMode;


    protected:

        void drawFatStroke(grafTag * PR, vector<ofPoint>&left,vector<ofPoint>&right, float grayVal, float aplha, bool bUseDrawShape=false, bool bUseLines = false);
        void drawFatOutline(grafTag * PR, vector<ofPoint>&left,vector<ofPoint>&right);

        void calculateStroke( grafTag * PR );
        void calculatePoint(timePt pt, float time_num, float dist, float angle, vector<ofPoint>&left, vector<ofPoint>&right);

        float getAlphaForLinePosition( int pos, int total );


        // draw positions of points

        // fast as thick points
        vector<ofPoint> leftPts;                // pts to make drawing of tangent lines faster
        vector<ofPoint> rightPts;


        // fast as slim points
        vector<ofPoint> leftPtsInv;              // pts to make drawing of tangent lines faster
        vector<ofPoint> rightPtsInv;

        vector<float> distSlim;



        bool bSwap;
        bool bUseAlphaMode;



    private:
};

#endif // GRAFVIZSTROKED_H
