#ifndef PTAGMANAGER_H
#define PTAGMANAGER_H

#include "ofMain.h"
#include "ofxAccelerometer.h"
#include "ofxMultiTouch.h"

#include "grafPlayer.h"
#include "grafTagMulti.h"
#include "grafDrawer.h"
#include "ofxiWebUploader.h"
#include "grafCurveSmoother.h"
#include "guiMenu.h"
#include "grafIO.h"

enum{ PMODE_START_MENU, PMODE_REC, PMODE_PLAY, PMODE_EDIT };
enum{ STROKE_SINGLE, STROKE_MULTI };

#define		UPLOAD_URL	"localhost"

#define		WEB_RESPONSE_UPLOADING	"...please wait."
#define		WEB_RESPONSE_SUCCESS	"Upload is a success!"
#define		WEB_RESPONSE_FAIL		"Upload failed."
#define		WEB_RESPONSE_NO_CONNECT	"Cannot connect."


class dustTagManager : public ofxMultiTouchListener 
{
    public:
        dustTagManager();
        virtual ~dustTagManager();

        void setup();
		void reset();
        void update();
        void draw();
		
		// interface and switching modes
		void switchToPlayer();
		void startRecording();
		void resetPlayer(bool bUseNext = true);
		void nextTag();
		void clearAll();
	
	
		// draws
		void drawStartMenu();
		void drawRecording();
		void drawPlayer();
		void drawUploadStatus();
		void drawTime(float time);
	
		// user input
		void touchDown(float x, float y, int touchId, ofxMultiTouchCustomData *data = NULL);
		void touchMoved(float x, float y, int touchId, ofxMultiTouchCustomData *data = NULL);
		void touchUp(float x, float y, int touchId, ofxMultiTouchCustomData *data = NULL);
		void touchDoubleTap(float x, float y, int touchId, ofxMultiTouchCustomData *data = NULL);		
		
		void uploadTag();
	
    protected:

		//---------------- web		
		ofxiWebUploader wUploader;
		grafIO			grafXmlMaker;
		string			webResponse;
	
		//---------------- tags
		
		// stores data for the current tag being recorder
		grafTagMulti		myTag;
	
		// player to animate the tag 
		grafPlayer	myTagPlayer;
		
		// vectors of all tags recorded this session
		vector<grafTagMulti>			tags;
		
		// smooths curve for nice drawing
		grafCurveSmoother				smoother;
	
		// id of the current tag being played
		int currentTagID;
		
		//---------------- animation
		float		rotateBlend;
		ofPoint		tagPosVel;
		float		tagBlendZoom;
		float		tagMoveForce;
	
	
		//---------------- drawing
		grafDrawer		lineDrawer;
		bool			bShowTimeLine;
		bool			bUploading;
		bool			bDrewUploading;
		float			uploadStatusAlpha;
		bool			bPlayAll;
		
		//---------------- interface	
		int		mode;					// current mode -- recording, uploading, playing
		int		strokeMode;				// single or double stroke
		float	screenW, screenH;	
		
		guiMenu					gMenu;	// interface, menus
		
		ofTrueTypeFont			font;
		ofTrueTypeFont			fontSM;
		ofTrueTypeFont			fontSSM;
		ofTrueTypeFont			titleFont;
	
		ofImage					bgImage;
		ofTexture				bgTex;
		float					startMenuAlpha;
	
		float					waitTimer;
		float					waitTime;
		
	
		// touch data
		ofPoint touch[2];
		bool	touchOn[2];
		float	prevDist;
	
		bool bMenuOptionsOn;

    private:
};

#endif // PTAGMANAGER_H
