#ifndef GRAFMANAGER_H
#define GRAFMANAGER_H

#include "ofMain.h"
#include "ofxAccelerometer.h"
#include "ofxMultiTouch.h"

#include "grafTag.h"
#include "grafRecorder.h"
#include "grafVStroke.h"
#include "grafVParticleField.h"
#include "ofxXmlSettings.h"
#include "grafIO.h"
#include "guiManager.h"
/*
#include "guiSlider.h"
#include "guiButton.h"
#include "guiButtonGroup.h"
#include "guiManager.h"
 */


/*
Main class to manage

*/


enum{ MODE_NORM, MODE_TRANS, MODE_REC, MODE_START_MENU, MODE_LOAD_MENU, MODE_SAVE_MENU, MODE_EDIT_TAG };


class grafManager : public ofxMultiTouchListener 
{
    public:
        grafManager();
        virtual ~grafManager();

        void setup();

        // clears all 
        void reset();

        // updates recording, animation and transitions
        void update();
		bool updateTransitions( grafTag * tag, float dt );
		
        // draws current visuals to screen
        void draw();
		void drawStartMenu();
		void drawPlayback();
		void drawRecording();
		void drawRecordButton();
		void drawPauseButton();
	
		// tag management
		void resetTag();
		void nextTag();
		void adjustTagPos( int x, int y );
	
		// user input
		void touchDown(float x, float y, int touchId, ofxMultiTouchCustomData *data = NULL);
		void touchMoved(float x, float y, int touchId, ofxMultiTouchCustomData *data = NULL);
		void touchUp(float x, float y, int touchId, ofxMultiTouchCustomData *data = NULL);
		void touchDoubleTap(float x, float y, int touchId, ofxMultiTouchCustomData *data = NULL);		
		
		// gui setup and control
		void setupGuiControls();
		
		// interface
		guiManager				* gui;
		guiManager				* guiStart;
		guiManager				* guiEdit;
		guiManager				* guiView;
	
		
		// recording and smoothingç
		grafRecorder			* recorder;				// records a tag
		grafCurveSmoother		* smoother;		


        // tags
		vector<grafTag>         myTags;					// vector of all loaded or recorded tags
	
	
		// visuals
		grafVStroke				* vizStroke;			// object to calculate and draw a thick stroked line
		
		// transition params
		float avgRate;
		float fadeRate;
	
		// touch data
		ofPoint touch[2];
		bool	touchOn[2];
		float	prevDist;
	
		float	screenW, screenH;
		float	recScale;
		int		currentTag;
		float	rotation;
		
	
		// time data
		float                   waitTime;				// time (in seconds) to wait before playing transition to next tag
		float                   waitCounter;			// counter to countdown wait time
		float                   lastTime;				// last time of render , for time based animatoin
		float                   dt;						// time difference from last frame
		
		ofTrueTypeFont			franklinBook;
		ofTrueTypeFont			franklinBookSM;
		ofTrueTypeFont			franklinBookSSM;
	
		ofImage					bgImage;
		float					bgAlpha;
		float					pressAgainAlpha;
		float					alphaPause;
		
	
    protected:

		
		// states
		bool bPlaying;
		bool bReadyToRecord;
		int	 mode;
		int nRecordings;


    private:
};

#endif // GRAFMANAGER_H
