#include "grafTag.h"


grafTag::grafTag()
{

    bPaused         = false;
    bReset          = false;

    startTime       = 0.f;
	maxNumPts       = 5000;
	ptStart         = 0;
	ptEnd           = 0;
	prevId			= -1;

    timeCounter     = 0.f;
    timeOfLastFrame = 0.f;
    timeInRange     = 0.f;

	nowIndex        = 0;
    nowDist         = 0.f;
    nowAngle        = 0.f;
    nowPointForTime.set(0,0,0);

    rotation.set(0,0,0);
    position.set(0,0,1);
    z_const     = 10.f;
	
	minPtDist = 0.001 ;

    bPlayed = false;
	tagname = "graf";
}

grafTag::~grafTag()
{
    //dtor
}

void grafTag::clear()
{
    pts.clear();
	pts_orig.clear();
	prevId = -1;
}

void grafTag::update()
{

    //----- don't do it if there are no points
    if( pts.size() == 0 ) return;

    //----- check time change to update animation
    float diffTime		        = ofGetElapsedTimef() - timeOfLastFrame;
	timeOfLastFrame		        = ofGetElapsedTimef();
	if(!bPaused) timeCounter	+= diffTime;


    //------ set current point and time
    nowPointForTime = getPointForTime( timeCounter, nowIndex, nowDist, nowAngle);

    //cout << nowIndex << " " << diffTime << endl;
	
	//------ check in case time jumps over end pt
    if( nowIndex > ptEnd )
        nowPointForTime = getPointForTime(pts[ptEnd-1].time,nowIndex, nowDist, nowAngle);


    //----- test for reset -- check last point and first in case time jump goes over
    if( nowIndex == ptEnd  || (nowIndex == 0 && bPlayed) ){
         //bReset = true;
        // nowPointForTime = getPointForTime(pts[ptEnd-1].time,nowIndex, nowDist, nowAngle);
		//cout << "breset0 played" << endl;
    }

    if( nowIndex < prevId )
	{ 
		//cout << "reset " << prevId << " " << nowIndex << endl; 
		bReset = true; 
		nowPointForTime = getPointForTime(pts[ptEnd-1].time,nowIndex, nowDist, nowAngle); 
	}
	
	//----- tag has been played
    bPlayed = true;
	
	prevId = nowIndex;

}

bool grafTag::addNewPoint(ofPoint pt, float dist, float angle, float time, bool bAverage)
{

    //----- ignore 0,0 error
    if( pt.x == 0 && pt.y == 0) return false;


    //----- on the first point, grab the start time
	if (pts.size() == 0){
		if(time == -1 ) startTime = ofGetElapsedTimef(); 
		else startTime = time;
	}

    //----- combine the position and the time here:
	timePt	myPoint;
	myPoint.x = pt.x;
	myPoint.y = pt.y;
	myPoint.z = pt.z;
	
	if( time == -1 )    myPoint.time	= ofGetElapsedTimef() - startTime;
    else                myPoint.time    = time;

	
	//----- set z from time position
	myPoint.z = ( myPoint.time * 1000.f ) / z_const;
	
	
	//----- check distance and return if too small
    if( pts.size() > 0 && dist == -1 )          dist = ((ofxVec2f)(pts[pts.size()-1]-pt)).length();
    else if ( pts.size() == 0 && dist == -1 )   dist = 0;

    if( pts.size() == 0 || dist >minPtDist ) myPoint.dist = dist;
    else{ 
		printf("grafTag: can´t add, dist too small \n"); 
		return false; 
	}

	//----- calc angle from previous point
	if( pts.size() > 0 && angle == -1) angle = atan2(pt.y - pts[pts.size()-1].y, pt.x - pts[pts.size()-1].x);
	else if(angle == -1) angle = 0;
	myPoint.angle = angle;


	//----- add and check if point is misplaced (in case doing curved smoothing)
	int inPt = -1;
	for( int i = 0; i < pts.size(); i++)
	{
        if( pts[i].time > myPoint.time )
        {
            inPt = i;
            break;
        }
    }

    //----- add the point
	if( inPt == -1 || pts.size() == 0 )
    {
        pts.push_back(myPoint);
        pts_orig.push_back(myPoint);
    }
    else{
         pts.insert(pts.begin()+inPt,myPoint);
         pts_orig.insert(pts_orig.begin()+inPt,myPoint);
    }

	//----- delete if overrun limit
	if (pts.size() > maxNumPts)
	{
		pts.erase(pts.begin());
	}


    int numPoints = pts.size()-1;

    //----- average
    if( numPoints > 1 && bAverage)
    {
        pts[numPoints-1].x = (0.2f * pts[numPoints-2].x) + (0.60f * pts[numPoints-1].x) + (0.2f * pts[numPoints].x);
        pts[numPoints-1].y = (0.2f * pts[numPoints-2].y) + (0.60f * pts[numPoints-1].y) + (0.2f * pts[numPoints].y);
        pts[numPoints-1].dist  = (0.25f * pts[numPoints-2].dist) + (0.50f * pts[numPoints-1].dist)  + (0.25f * pts[numPoints].dist);
    }

    ptEnd =  pts.size()-1;


    //-----  originals
	if(pts_orig.size() > maxNumPts)
	{
		pts_orig.erase(pts_orig.begin());
	}

    
	
	
	//-----  
	return true;
}

void grafTag::setCurrentToLast()
{
	nowIndex			= pts.size()-1;
	nowPointForTime		= pts[nowIndex];
	nowDist				= pts[nowIndex].dist;
	nowAngle			= pts[nowIndex].angle;
	timeInRange			= pts[nowIndex].time;
	ptEnd				= nowIndex;
}

void grafTag::averagePts()
{
    for( int i = 2; i < pts.size(); i++)
    {

       // pts[i-1].x = (0.3f * pts[i-2].x) + (0.40f * pts[i-1].x) + (0.3f * pts[i].x);
       // pts[i-1].y = (0.3f * pts[i-2].y) + (0.40f * pts[i-1].y) + (0.3f * pts[i].y);
       // pts[i-1].dist  = (0.2f * pts[i-2].dist)  + (0.60f * pts[i-1].dist)  + (0.2f * pts[i].dist);
        pts[i-1].dist  = (0.25f * pts[i-2].dist)  + (0.50f * pts[i-1].dist)  + (0.25f * pts[i].dist);


    }

}

ofPoint grafTag::getPointForTime(    float time, int & whatPointAmINear, float & dist, float & angle)
{

	if (pts.size() <= 1) return ofPoint(0,0,0);

	float totalTime     = getDuration();
    timeInRange         = time;

	while (timeInRange > totalTime){
		timeInRange -= totalTime;
	}

	whatPointAmINear = 0;
	for (int i = 0; i < pts.size(); i++){

		if (pts[i].time > timeInRange){
			whatPointAmINear = i;
			break;
		}
	}

	if (whatPointAmINear > 0){

		float timea = pts[whatPointAmINear - 1].time;
		ofPoint pta = pts[whatPointAmINear - 1];
		float timeb = pts[whatPointAmINear    ].time;
		ofPoint ptb = pts[whatPointAmINear    ];

		float totalDurationBetweenThesePts	= timeb - timea;
		float myPositionBetweenThesePts		= timeInRange - timea;
		float pct = myPositionBetweenThesePts / totalDurationBetweenThesePts;

		ofPoint mix(0,0,0);
		mix.x = (1-pct) * pta.x + (pct) * ptb.x;
		mix.y = (1-pct) * pta.y + (pct) * ptb.y;
		mix.z = (1-pct) * pta.z + (pct) * ptb.z;

		dist  = (1-pct) * pts[whatPointAmINear - 1].dist + (pct) * pts[whatPointAmINear].dist;
		angle = (1-pct) * pts[whatPointAmINear - 1].angle + (pct) * pts[whatPointAmINear].angle;
		//angle = atan2(pts[whatPointAmINear].y - pts[whatPointAmINear - 1].y, pts[whatPointAmINear].x - pts[whatPointAmINear-1].x);

		return mix;

	} else {

		dist    = pts[whatPointAmINear].dist;
		angle   = pts[whatPointAmINear].angle;
		return pts[whatPointAmINear];
	}
}

ofPoint grafTag::getPointForTime( float time)
{

	if (pts.size() <= 1) return ofPoint(0,0,0);

	float totalTime       = getDuration();
    float myTimeInRange   = time;

	while (myTimeInRange > totalTime){
		myTimeInRange -= totalTime;
	}

	float whatAmINear = 0;
	for (int i = 0; i < pts.size(); i++){

		if (pts[i].time > myTimeInRange){
			whatAmINear = i;
			break;
		}
	}

	if (whatAmINear > 0){

		float timea = pts[whatAmINear - 1].time;
		ofPoint pta = pts[whatAmINear - 1];
		float timeb = pts[whatAmINear    ].time;
		ofPoint ptb = pts[whatAmINear    ];

		float totalDurationBetweenThesePts	= timeb - timea;
		float myPositionBetweenThesePts		= myTimeInRange - timea;
		float pct = myPositionBetweenThesePts / totalDurationBetweenThesePts;

		ofPoint mix(0,0,0);
		mix.x = (1-pct) * pta.x + (pct) * ptb.x;
		mix.y = (1-pct) * pta.y + (pct) * ptb.y;
		mix.z = (1-pct) * pta.z + (pct) * ptb.z;

		return mix;

	} else {
		return pts[whatAmINear];
	}
}

ofPoint grafTag::getVelocityForTime( float time)
{
    // ok the trick is to do the same as above (find the time in the gesture)
	// and to find a time slightly less... (prev position and current position).

	if (pts.size() <= 0) return ofPoint(0,0,0);

	float totalTime = getDuration();
	float timeInRange = time;

	while (timeInRange > totalTime){
		timeInRange -= totalTime;
	}

	float prevTime = MAX(0, timeInRange - 0.016666f); // time minus 1/60 of a second....
	//cout << timeInRange << " " << prevTime << endl;

	ofPoint curPoint	= getPointForTime(timeInRange);
	ofPoint prevPoint	= getPointForTime(prevTime);


	ofPoint velocity;

	velocity.x			= curPoint.x - prevPoint.x;
	velocity.y			= curPoint.y - prevPoint.y;

	return velocity;
}

ofPoint grafTag::getCurrentPoint()
{
    return nowPointForTime;
}

float   grafTag::getDuration()
{
    float totalDuration = 0;
	if (pts.size() > 0){
		totalDuration = pts[ptEnd].time;
	}
	return totalDuration;
}

float   grafTag::getCurentZDepth()
{
    return (timeInRange*1000) / z_const;
}

void grafTag::resetToStart()
{
    if( pts.size() == 0 ) return;
	nowIndex			= 0;
    timeCounter         = pts[0].time;
    timeOfLastFrame     = ofGetElapsedTimef();
	prevId				= -1;
	bReset				= false;
	bPlayed				= false;
	bPaused				= false;

}

void grafTag::calcMinMax()
{

    max.set(0,0,0);
    min.set(0,0,0);

    distMin = 0;
    distMax = 0;

    for( int i = 0; i < pts.size(); i++)
    {
        if( i == 0 || pts[i].x > max.x ) max.x = pts[i].x;
        if( i == 0 || pts[i].y > max.y ) max.y = pts[i].y;
        if( i == 0 || pts[i].time  > max.z ) max.z = pts[i].time;

        if( i == 0 || pts[i].x < min.x ) min.x = pts[i].x;
        if( i == 0 || pts[i].y < min.y ) min.y = pts[i].y;
        if( i == 0 || pts[i].time  < min.z ) min.z = pts[i].time;

        if( i == 0 || pts[i].dist  > distMax  ) distMax = pts[i].dist;
        if( i == 0 || pts[i].dist  < distMin  ) distMin = pts[i].dist;
    }

}

float grafTag::getPctDone()
{
    if (pts.size() == 0 ) return 0;
    else return (pts[ptEnd].time - pts[nowIndex].time) / pts[ptEnd].time;
}

grafTag::grafTag( const grafTag &  mom )
{
    pts.clear();
	pts_orig.clear();

	pts.assign( mom.pts.begin(), mom.pts.end() );
	pts_orig.assign( mom.pts_orig.begin(), mom.pts_orig.end() );


	bPaused					= mom.bPaused;
	bReset					= mom.bReset;

	rotation				= mom.rotation;
	position				= mom.position;
	z_const					= mom.z_const;

    startTime				= mom.startTime;
	maxNumPts				= mom.maxNumPts;
	ptStart					= mom.ptStart;
	ptEnd					= mom.ptEnd;

    timeCounter             = mom.timeCounter;
    timeOfLastFrame         = mom.timeOfLastFrame;
    timeInRange             = mom.timeInRange;

	nowIndex                = mom.nowIndex;
    nowDist                 = mom.nowDist;
    nowAngle                = mom.nowAngle;
    nowPointForTime         = mom.nowPointForTime;

    max                     = mom.max;
    min                     = mom.min;
    distMin                 = mom.distMin;
    distMax                 = mom.distMax;

    bPlayed                 = mom.bPlayed;
	drawScale				= mom.drawScale;
	
	tagname					= mom.tagname;

 }
