#ifndef GRAFVIZPARTICLES_H
#define GRAFVIZPARTICLES_H

#include "ofMain.h"
#include "grafTag.h"
#include "particleSystem.h"

class grafVParticleField
{
    public:
        grafVParticleField();
        virtual ~grafVParticleField();

	
		void setup(int w, int h);
		void reset();
	
		void update( grafTag * PR,ofPoint pointForTime, ofPoint vel, float dt, bool bUpdateVF=true);
		
		void setDamping( float val );
		void setParticleSize( float val );
	
		void draw( grafTag * PR, int screenW, int screenH );
	
	
	
		float alpha;
		float particle_damping;
		float particle_size;
		float particle_alpha;
	

    protected:
		
		int w, h;
	
		// particles with attached lines
		particleSystem  PS;
	
		// solo particles
		vector<particleSystem> XTRA_PS;
	
		// normal vector field
		vectorField     VF;
	
		int transitionCounter;
      
    private:
};

#endif // GRAFVIZPARTICLES_H
