#include "guiButton.h"

guiButton::guiButton()
{
    hitBox = ofRectangle(0,0,10,10);
    bOn = false;
	type = BUTTON_NORMAL;
	drawMode = DRAW_NORM;
	fade = 0;
}

guiButton::~guiButton()
{
    //dtor
}

void guiButton::setup(int x, int y, int w, int h, bool bOn_)
{
    name= " ";
    hitBox = ofRectangle(x,y,w,h);
    bOn = bOn_;
}
void guiButton::setup(string myname, int x, int y, int w, int h, bool bOn_, int val)
{
    name = myname;
    hitBox = ofRectangle(x,y,w,h);
    bOn = bOn_;
	value = val;
}

void guiButton::update()
{
    if( fade > 0 ) fade -= .05;
	
}

bool guiButton::hitTest(int x, int y, bool bSwitched)
{
    if( fade > 0 ) return false;
	
	if( pointInRectangle( hitBox,x,y) )
    {
        if(bSwitched) bOn = !bOn;
		fade = 1;
		return true;
    }
	
    return false;
	
	
}

void guiButton::draw()
{

    if( drawMode == DRAW_NONE ) return;
	
	switch( drawMode )
	{
		case DRAW_NORM:
			
			//if( value >= 0 ) 
			ofSetColor(value+(10*fade),value+(10*fade),value+(10*fade));
	
			if( bOn ) ofFill();
			else ofNoFill();

			ofRect( hitBox.x,hitBox.y,hitBox.width, hitBox.height);
			ofDrawBitmapString(name, hitBox.x+hitBox.width+3, hitBox.y+10);
			break;
		
		case DRAW_RECORD:
			
			ofNoFill();
			if( value >= 0 ) ofSetColor(value,value,value);
			ofCircle( hitBox.x+hitBox.width*.5,hitBox.y+hitBox.width*.5,hitBox.width);
			ofFill();
			ofCircle(hitBox.x+hitBox.width*.5,hitBox.y+hitBox.width*.5, hitBox.width*.25);
			
			break;
	}
}
