#include "guiMenu.h"

guiMenu::guiMenu()
{
    bHideKeyword = false;
	uniqueID = "";
}

guiMenu::~guiMenu()
{
    //dtor
}

void guiMenu::setup( ofPoint pos, int w, int h )
{
	
	keyboard = new ofxiPhoneKeyboard(0,0,500,500);
	keyboard->setText(" ");
	keyboard->setPosition(-200,50);
	
	HelveticaN.loadFont("frabk.ttf",10);
	fontOp.loadFont("HelveticaNeueMed.ttf",14);
	Gara.loadFont("GARA.TTF",20);
	
	screenW			= 320;
    screenH			= 480;
	
	int recH = w;
	
	names.push_back("RECORD");	xnames.push_back("STOP");
	names.push_back("RESET");	xnames.push_back("RESET");
	names.push_back("OPTIONS");	xnames.push_back("OPTIONS");
	
	btW = 0;
	
	for( int i = 0; i < names.size(); i++)
	{
		float wd = HelveticaN.stringWidth( names[i] );
		if(wd>btW) btW = wd;
	}
	
	btW += 10;
	
	for( int i = 0; i < names.size(); i++)
	{
		buttons.push_back( guiDustButton() );		
		float xp = (i==0)  ? 2 : 2+(btW+20)*i;
		buttons[i].setup( names[i],xnames[i],-2, xp, recH, btW+12,xp,320-recH+2, btW+12, recH );
		
	}
	
	guiDustButton * tempButton = getButton("RECORD");
	tempButton->setXName( "STOP" );
	
	obtW = 0;
	opnames.push_back("Add Keyword");
	opnames.push_back("Upload");
	opnames.push_back("Use Multi Stroke");
	opnames.push_back("Clear All Tags");
	opnames.push_back("Play All Tags");
	
	for( int i = 0; i < opnames.size(); i++)
	{
		float wd = HelveticaN.stringWidth( opnames[i] );
		if(wd>obtW) obtW = wd;
	}
	obtW+=10;
	
	obtW = screenH;
	float ht = 42;
	for( int i = 0; i < opnames.size(); i++)
	{
		opbuttons.push_back( guiDustButton() );		
		
		float yp = (i==0)  ? 30 : 30+(ht*i);
		//opbuttons[i].setup( opnames[i], screenW-yp-recH, 60, recH, obtW+12,60,yp, obtW+12, recH );
		opbuttons[i].setup( opnames[i], (screenW-yp-ht)+6, 0, ht-12, obtW+2, 0,yp, obtW+2, ht );
	}
	
	opnames.push_back("X");
	opXButton.setup("x","x",15,screenH-45,30,30,15,screenH-45,30,30);
	opXButton.fadeRate = .1;
	
	opnames.push_back("Upload Now");
	opSendButton.setup( "Upload Now", (screenW-170-ht)+6, 0, ht-12, obtW+2, 0,170, obtW+2, ht );
	
	opnames.push_back("Credits");
	opCreditsButton.setup("Credits","Credits", (screenW-270-ht)+6, 0, ht, obtW-70, 0,270, obtW-70, ht);
	
	xImage.loadImage("x.jpg");
	
	pos.set(0,0,0);
	dst.set(0,0,0);
	mainAlpha = 1;
	mainAlphaTime = 0;
	
	opmainAlpha = 0;
	opAlphaTime = .5; 
	opAlphaDst	= 0;
	
	
	tempButton = getButton("Use Multi Stroke");
	tempButton->bShowState = true;
	tempButton = getButton("Play All Tags");
	tempButton->bShowState = true;
	
	
}

guiDustButton * guiMenu::getButton( string name )
{
	for(int i = 0; i < buttons.size(); i++)
	{
		if( buttons[i].name == name ) return &buttons[i];
	}
	
	for(int i = 0; i < opbuttons.size(); i++)
	{
		if( opbuttons[i].name == name ) return &opbuttons[i];
	}
	
	
	if( name == "Credits" ) return &opCreditsButton;
	if( name == "X") return &opXButton;
			
	return NULL;
}


void guiMenu::closeOptionsMenu()
{
	switchButton("OPTIONS",false);
	keyboard->setVisible(false);
	cout << "close" << endl;
	
}

string guiMenu::hitTest( int x, int y )
{
	string code = "none";
	
	// check options open
	if( isActive("OPTIONS") ) 
	{
		
		for( int i = 0; i < opbuttons.size(); i++)
		{
			if( !isActive("Upload") && !isActive("Add Keyword") && !isActive("Credits") && opbuttons[i].hitTest(x, y) ) code = opnames[i];
		}
		
		
		if(keywords.size() > 45 ) keywords.erase(keywords.begin()+45, keywords.end());
		
		// check keyboard open
		if( isActive("Add Keyword")  )
		{
			keyboard->setVisible(true);
			keyboard->openKeyboard();
			keyboard->setText(keywords);
			bHideKeyword = true;
		}else{
			keyboard->setVisible(false);
			bHideKeyword = false;
		}
		
		
		
		if( opXButton.hitTest(x, y) ) 
		{
				if( isActive("Upload") )
				{
					switchButton("Upload", false);
				}else if( isActive("Credits") )
				{
					switchButton("Credits", false);
				}else{
					closeOptionsMenu();
					opAlphaTime = 0;				
				}
				code = "X";
			}
		
			if( isActive("Upload") && opSendButton.hitTest(x, y) )
			{
				code = "Upload Now";
			}
		
			if( !isActive("Upload") && opCreditsButton.hitTest(x,y) )
			{
				code="Credits";
			}
		}
	
	
	else{
		
		for( int i = 0; i < buttons.size(); i++)
		{
			if( buttons[i].hitTest(x, y) ) code = names[i];
		}
	
		switchButton("RESET",false);
	
		guiDustButton * tempB = getButton("RECORD");
		if( isActive("Use Multi Stroke") )
		{
			tempB->setUseXName(true);
		}
		else
		{
			tempB->setUseXName(false);
		}
		
		if( isActive("RECORD") && code == "OPTIONS"){
			code = "none";
			switchButton("OPTIONS",false);
		}
			
	}
	
	
	if(code == "OPTIONS" || code == "Add Keyword" || code == "Upload"|| code == "Credits") opAlphaTime = 0;
	
	return code;
}

void guiMenu::update(float dt)
{
	
	keywords = keyboard->getText();
	
	if( isActive("Add Keyword") ) keywords = keyboard->getText();
		
	if(keyboard->isKeyboardShowing() == false ) 
	{
		bHideKeyword = false;
		keyboard->setVisible(false);
		if( isActive("Add Keyword") )
		{
			keywords = keyboard->getText();
			switchButton("Add Keyword",false);
			opAlphaTime = 0;
		}
	}
	
	
	for( int i = 0;  i < buttons.size(); i++)
		buttons[i].update();
	
	for( int i = 0;  i < opbuttons.size(); i++)
		opbuttons[i].update();

	opXButton.update();
	opSendButton.update();
	opCreditsButton.update();
	
	// update motion and alpha of menus
	mainAlphaTime += dt;
	float pct = mainAlphaTime / 2.f ; 
	mainAlpha = pct;
	
	if( isActive("OPTIONS") && !isActive("Add Keyword") && !isActive("Upload") && !isActive("Credits") )
	{
		opAlphaTime += dt;
		float pct = opAlphaTime / .5f ; 
		opmainAlpha = MIN(1,pct);
		
		cout << "opMainAlpha " << opmainAlpha << endl;
		
	}
	else{
		opAlphaTime += dt;
		float pct = opAlphaTime / .5f ; 
		opmainAlpha = MAX(0,1-pct);
	}
	
}

void guiMenu::draw()
{
	
	
	bool bOptions = isActive("OPTIONS");
	

	glPushMatrix();
		
			if( isActive("Add Keyword") || isActive("Upload") || isActive("Credits"))
			{
				ofFill();
				ofSetColor(0, 0, 0, 240);
				ofRect( -2,-2,screenW+4,screenH+4);
				
				ofNoFill();
				ofSetColor(255,255,255,60*(1-opmainAlpha));
				opXButton.draw();
				
				ofEnableAlphaBlending();
				ofSetColor(255,255,255,255*(1-opmainAlpha));//100*(1-opmainAlpha));
				xImage.draw( opXButton.drawBox.x+4, opXButton.drawBox.y+4,opXButton.drawBox.width*.75, opXButton.drawBox.height*.75);
				
				
			}		
			
			ofFill();
			ofSetColor(0, 0, 0, 240*opmainAlpha);
			ofRect( -2,-2,screenW+4,screenH+4);
			
			ofNoFill();
			ofSetColor(90, 90, 90, 240*opmainAlpha);
			//ofRect( 50,-2,screenW-75,screenH+2);
			
			ofNoFill();
			ofSetColor(255,255,255,60*opmainAlpha);
			opXButton.draw();
			
			ofSetColor(255,255,255,255*opmainAlpha);
			xImage.draw( opXButton.drawBox.x+4, opXButton.drawBox.y+4,opXButton.drawBox.width*.75, opXButton.drawBox.height*.75);
			
			//opXButton.draw();
	
	glPopMatrix();
	
	
	glPushMatrix();
	
			glTranslatef(screenW/2.f, screenH/2.f,0);
			glRotatef(90, 0, 0, 1);
			glTranslatef(-screenH/2.f, -screenW/2.f,0);
	
			for( int i = 0; i < opbuttons.size(); i++)
			{
				ofFill();
				ofSetColor(40*opbuttons[i].fade,40*opbuttons[i].fade,40*opbuttons[i].fade,255*opmainAlpha);
				opbuttons[i].draw();
				
				ofNoFill();
				ofSetColor(100,100,100,255*opmainAlpha);
				opbuttons[i].draw();
				
				//if(opbuttons[i].bOn)	ofSetColor(255,0,0,255*opmainAlpha);
				//else					ofSetColor(255,255,255,255*opmainAlpha);
				
				ofSetColor(255,255,255,255*opmainAlpha);
				
				opbuttons[i].drawName(&fontOp,40,24,false);
				
				if( opbuttons[i].bShowState )
				{
					if(opbuttons[i].bOn)	ofSetColor(255,255,255,255*opmainAlpha);
					else					ofSetColor(255,255,255,180*opmainAlpha);
					
					if(opbuttons[i].bOn) HelveticaN.drawString("ON", 440, opbuttons[i].drawBox.y + 24);
					else HelveticaN.drawString("OFF", 440, opbuttons[i].drawBox.y + 24);
				}
				
				//opCreditsButton.draw();
			}
			
			if( isActive("Add Keyword") )
			{
				ofSetColor(180,180,180,(255*(1-opmainAlpha))*mainAlpha);
				HelveticaN.drawString("Keywords are added to the gml file when uploaded.", 50,80);//opbuttons[0].drawBox.x+(opbuttons[0].drawBox.width+10),opbuttons[0].drawBox.y+17);
				HelveticaN.drawString("Note: use commas to separate.", 50,100);//opbuttons[0].drawBox.x+(opbuttons[0].drawBox.width+10),opbuttons[0].drawBox.y+17);
				
				//ofSetColor(255,255,255,(255*(1-opmainAlpha))*mainAlpha);
				//HelveticaN.drawString("Current Keywords:   " + keywords, 50,100);//opbuttons[0].drawBox.x+(opbuttons[0].drawBox.width+10),opbuttons[0].drawBox.y+17);
			}
	
			ofSetColor(255,255,255,180*opmainAlpha);
			HelveticaN.drawString("Graffiti Analysis 2.0: DustTag by Evan Roth and Chris Sugrue", 40, 300);
			//

			if( isActive("Upload") )
			{
				ofSetColor(180,180,180,(255*(1-opmainAlpha))*mainAlpha);
				fontOp.drawString("000000book.com",40,50);
				HelveticaN.drawString("All tags are uploaded to 000000book.com, an online database\nof gml tags. Retrieve your tag by adding descriptive keywords or \nusing your iPhone's unique ID: ", 40,80);//opbuttons[0].drawBox.x+(opbuttons[0].drawBox.width+10),opbuttons[0].drawBox.y+17);
				HelveticaN.drawString(uniqueID, 40,140);//opbuttons[0].drawBox.x+(opbuttons[0].drawBox.width+10),opbuttons[0].drawBox.y+17);

				
				ofFill();
				ofSetColor(40*opSendButton.fade,40*opSendButton.fade,40*opSendButton.fade,(255*(1-opmainAlpha))*mainAlpha);
				opSendButton.draw();				
				
				ofNoFill();
				ofSetColor(100,100,100,(255*(1-opmainAlpha))*mainAlpha);
				opSendButton.draw();
				
				ofSetColor(255,255,255,(255*(1-opmainAlpha))*mainAlpha);
				opSendButton.drawName(&fontOp,40,24,false);
			}
	
	
			if( isActive("Credits") )
			{
				ofSetColor(180,180,180,(255*(1-opmainAlpha))*mainAlpha);
				
				Gara.drawString("Graffiti Analysis",40,50);
				
				HelveticaN.drawString("DustTag\nVersion 1.0\nDec. 6, 2009", 40,80);
				
				HelveticaN.drawString("Graffiti Analysis by Evan Roth.", 40,140);

				HelveticaN.drawString("All programming for DustTag by Chris Sugrue.", 40,160);

				HelveticaN.drawString("DustTag complies with all Graffiti Markup Language (GML) standards.", 40,200);

				HelveticaN.drawString("GNU General Public License", 40,220);

				HelveticaN.drawString("Built with openFrameworks.", 40, 240);
				
				HelveticaN.drawString("graffitianalysis.com", 40,280);
					
			}
	
	
	
		glPopMatrix();

	
	if( !bOptions )
	{
		//---- main menu
		glPushMatrix();
			
			glTranslatef(screenW/2.f, screenH/2.f,0);
			glRotatef(90, 0, 0, 1);
			glTranslatef(-screenH/2.f, -screenW/2.f,0);
			
			ofFill();
			
			for( int i = 0; i < buttons.size(); i++)
			{
				ofSetColor(0+(60*buttons[i].fade),+(60*buttons[i].fade),+(60*buttons[i].fade),255*mainAlpha);
				buttons[i].draw();
			}
		
			
			ofNoFill();
			ofSetColor(255,255,255,255*mainAlpha);
			
			for( int i = 0; i < buttons.size(); i++)
				buttons[i].draw();
			
			
			for( int i = 0; i < names.size(); i++)
			{
				if(buttons[i].bOn)	ofSetColor(255,0,0,255*mainAlpha);
				else				ofSetColor(255,255,255,255*mainAlpha);
				buttons[i].drawName(&HelveticaN,0,17);
			}
		
		glPopMatrix();
	}

}


bool  guiMenu::isActive( string buttonName )
{
	for( int i = 0; i < buttons.size(); i++){
		if( names[i] == buttonName && buttons[i].bOn) return true;
	}
	
	for( int i = 0; i < opbuttons.size(); i++){
		if( opnames[i] == buttonName && opbuttons[i].bOn) return true;
	}
	
	if( buttonName == "Credits" && opCreditsButton.bOn ) return true;
	
	return false;
}


void  guiMenu::switchButton( string buttonName, bool bVal )
{
	for( int i = 0; i < buttons.size(); i++){
		if( names[i] == buttonName)
		{
			buttons[i].bOn = bVal;
			return;
		}
	}
	
	for( int i = 0; i < opbuttons.size(); i++){
		if( opnames[i] == buttonName )
		{
			opbuttons[i].bOn = bVal;
			return;
		}
	}
	
	if( buttonName == "Credits" ) opCreditsButton.bOn = bVal;

}


