#include "guiSlidingDrawer.h"

guiSlidingDrawer::guiSlidingDrawer()
{
    
}

guiSlidingDrawer::~guiSlidingDrawer()
{
    //dtor
}

void guiSlidingDrawer::setup( ofPoint pOpen, ofPoint pClose, int w, int h )
{
	posOpen		= pOpen;
	posClosed	= pClose;
	
	sDrawer.setup( pClose.x, pClose.y, w, h );
	openButton.setup( pClose.x, pClose.y, w, 30 );
	
	int recH = ( h - openButton.hitBox.height - 30 );
	recordButton.setup(  pClose.x, pClose.y, recH, recH );
	uploadButton.setup(  pClose.x, pClose.y, recH, recH );
	cancelButton.setup(  pClose.x, pClose.y, recH, recH );
	
	buttonMargin.set( (w-recH*3)/4.f ,15);
	
	moveMode	= GMOVE_MODE_OPEN;
	moveCounter = 0.f;
	moveSpeed	= .8;
	
	update(0);
}

void guiSlidingDrawer::update(float dt)
{
    
	if( moveMode == GMOVE_MODE_OPEN )
	{
		if( moveCounter < 1 ) moveCounter += moveSpeed*dt;
		else moveCounter = 1;
		
		sDrawer.hitBox.x = (1-moveCounter) * sDrawer.hitBox.x + moveCounter * posOpen.x;
		sDrawer.hitBox.y = (1-moveCounter) * sDrawer.hitBox.y + moveCounter * posOpen.y;
		
	}else if ( moveMode == GMOVE_MODE_CLOSE ){
		
		if( moveCounter < 1 ) moveCounter += moveSpeed*dt;
		else moveCounter = 1;
		
		sDrawer.hitBox.x = (1-moveCounter) * sDrawer.hitBox.x + moveCounter * posClosed.x;
		sDrawer.hitBox.y = (1-moveCounter) * sDrawer.hitBox.y + moveCounter * posClosed.y;
	}
	
	openButton.hitBox.x = sDrawer.hitBox.x;
	openButton.hitBox.y = sDrawer.hitBox.y;
	
	cancelButton.hitBox.x = sDrawer.hitBox.x + buttonMargin.x;
	cancelButton.hitBox.y = openButton.hitBox.y + openButton.hitBox.height + buttonMargin.y;
	
	uploadButton.hitBox.x = sDrawer.hitBox.x + 2*buttonMargin.x + 1*uploadButton.hitBox.width;
	uploadButton.hitBox.y = openButton.hitBox.y + openButton.hitBox.height + buttonMargin.y;
	
	recordButton.hitBox.x = sDrawer.hitBox.x + 3*buttonMargin.x + 2*recordButton.hitBox.width;
	recordButton.hitBox.y = openButton.hitBox.y + openButton.hitBox.height + buttonMargin.y;
	
}

int guiSlidingDrawer::hitTest( int x, int y )
{
	if( openButton.hitTest(x, y) )
	{
		if(		moveMode == GMOVE_MODE_OPEN )		moveMode = GMOVE_MODE_CLOSE;
		else if( moveMode == GMOVE_MODE_CLOSE )		moveMode = GMOVE_MODE_OPEN;
					
		moveCounter = 1-moveCounter;
		return 0;
	
	}else if( recordButton.hitTest(x, y) )
	{
		moveMode = GMOVE_MODE_CLOSE;
		moveCounter = 1-moveCounter;
		
		return 1;
		
	}else if( uploadButton.hitTest(x, y) )
	{
		return 2;
	
	}else if( cancelButton.hitTest(x, y) )
	{
		return 3;
	}
	
	return -1;
}


void guiSlidingDrawer::draw()
{
	//sDrawer.draw();
	ofFill();
	ofSetColor(0, 0, 0, 150);
	ofRect( sDrawer.hitBox.x,sDrawer.hitBox.y,sDrawer.hitBox.width, sDrawer.hitBox.height);
	
	ofNoFill();
	ofSetColor(255, 255, 255, 250);
	ofRect( sDrawer.hitBox.x,sDrawer.hitBox.y,sDrawer.hitBox.width, sDrawer.hitBox.height);
	
	ofSetColor(255, 255, 255, 250);
	ofRect( openButton.hitBox.x,openButton.hitBox.y,openButton.hitBox.width, openButton.hitBox.height);


	// record button
	ofSetColor(255, 255, 255, 200);
	ofNoFill();
	ofCircle( recordButton.hitBox.x+recordButton.hitBox.width*.5,recordButton.hitBox.y+recordButton.hitBox.width*.5,recordButton.hitBox.width*.5);
	
	//ofSetColor(255, 0, 0, 250);
	ofCircle( recordButton.hitBox.x+recordButton.hitBox.width*.5,recordButton.hitBox.y+recordButton.hitBox.width*.5,recordButton.hitBox.width*.15);

	ofFill();
	ofCircle( recordButton.hitBox.x+recordButton.hitBox.width*.5,recordButton.hitBox.y+recordButton.hitBox.width*.5,recordButton.hitBox.width*.1);

	
	// upload button
	ofSetColor(255, 255, 255, 200);
	ofNoFill();
	ofCircle( uploadButton.hitBox.x+uploadButton.hitBox.width*.5,uploadButton.hitBox.y+uploadButton.hitBox.width*.5,uploadButton.hitBox.width*.5);
	
	// cancel button
	ofSetColor(255, 255, 255, 200);
	ofNoFill();
	ofCircle( cancelButton.hitBox.x+cancelButton.hitBox.width*.5,cancelButton.hitBox.y+cancelButton.hitBox.width*.5,cancelButton.hitBox.width*.5);
	
	
	
	
	
}
