﻿package com.manolis.display.geometry
{

	import flash.display.Sprite;
	import flash.display.Shape;
	import flash.events.Event;
	import flash.display.Graphics;

	public class Geometrics extends Sprite
	{

		protected var rW:Number=new Number();
		protected var rH:Number=new Number();
		protected var rX:Number=new Number();
		protected var rY:Number=new Number();
		private var devider:Array=new Array();
		private var _lineColor:uint;
		private var _fillColor:uint;
		private var _lineThickness:Number;
		private var _fill:Boolean;

		/*
		*
		*  pivot can take the following values CENTER,TOP_LEFT,TOP_RIGHT,BOTTOM_LEFT,BOTTOM_RIGHT,CUSTOM
		*
		*/


		public function Geometrics(_rW:Number,_rH:Number,lS:Number=1,_pivot:String="CENTER",fC:uint=0xffffff,lC:uint=0x000000,_rX:Number=0,_rY:Number=0):void
		{
			///////////////////// DECLARING VARS ////////////////
			devider        = verifyPivot(_pivot);
			rW             = _rW;
			rH             = _rH;
			rX             = _rX;
			rY             = _rY;
			_lineColor     = lC;
		    _fillColor     = fC;
		    _lineThickness = lS;
			_fill          = true;

			if (devider!=null)
			{
				rX = -rW*devider[0];
				rY = -rH*devider[1];
			}
			
			if (stage)
			{
				init();
			}
			else
			{
				addEventListener(Event.ADDED_TO_STAGE,init,false,0,true);
			}
		}
		
		private function init(e:Event = null):void
		{
			removeEventListener(Event.ADDED_TO_STAGE,init);
		    renderShape();
			addEventListener(Event.REMOVED_FROM_STAGE,killPivot,false,0,true);
		}
		
		protected function renderShape():void
		{
            graphics.clear();
			if(lineThickness!=0) graphics.lineStyle(_lineThickness,_lineColor,1,true, "none");
			if(fill) graphics.beginFill(_fillColor);
			graphics.drawRect(rX,rY,rW,rH);
		}
		
		public function updateGeometry(_rW:Number,_rH:Number,_rX:Number=0,_rY:Number=0):void
		{
			graphics.clear();
			if(_rX!=rX || _rY!=rY)
			{
				rX=_rX;
		        rY=_rY;
			}
			rW=_rW;
		    rH=_rH;
		    renderShape();
			
		}
		
		public function set showPivot(switchOnOff:Boolean):void
		{
			if(switchOnOff)
			{
			    var pivotS:Shape=new Shape();
			    addChild(pivotS);
			    with(pivotS)
			    {   
				   graphics.lineStyle(1,0x000000);
			       graphics.moveTo(0,-5);
			       graphics.lineTo(0,5);
			       graphics.moveTo(-5,0);
			       graphics.lineTo(5,0);
			    }
			}
			else
			{
				
			    if(pivotS!=null)
			    {   
		            removeChild(pivotS);
			        pivotS=null;
			    }
			}
		}
		
		private function verifyPivot(_pivot:String):Array
		{
			switch (_pivot)
			{
				case "CENTER" :
					return new Array(0.5,0.5);
					break;
				case "TOP_LEFT" :
					return new Array(0,0);
					break;
				case "TOP_RIGHT" :
					return new Array(1,0);
					break;
				case "BOTTOM_LEFT" :
					return new Array(0,1);
					break;
				case "BOTTOM_RIGHT" :
					return new Array(1,1);
					break;
				case "CUSTOM" :
					return null;
					break;
				case "" :
					throw new Error("PLEASE SPECIFY A PIVOT POINT. THE PIVOT POINT CAN TAKE THE FOLLOWING VALUES: CENTER,TOP_LEFT or CUSTOM ");
					return null;
					break;
				default :
					throw new Error("Invalid pivot value.");
					return null;
					break;

			}
		}
		
		public function set lineColor(_color:uint):void
		{
			_lineColor=_color;
			renderShape();
		}
		
		public function get lineColor():uint
		{
			return _lineColor;
		}
		
		public function set fillColor(_color:uint):void
		{
			
			_fillColor=_color;
			renderShape();
		}
		
		public function get fillColor():uint
		{
			
			return _fillColor;
		}
		
		public function set lineThickness(_size:uint):void
		{
			
			_lineThickness=_size;
			renderShape();
		}
		
		public function get lineThickness():uint
		{
			
			return _lineThickness;
		}
		public function set fill(_value:Boolean):void
		{
			
			_fill=_value;
			renderShape();
		}
		
		public function get fill():Boolean
		{
			
			return _fill;
		}
		
		///////////////////////// EVENT HANDLERS //////////////////////
		private function killPivot(e:Event):void
		{
			showPivot=false;
			removeEventListener(Event.REMOVED_FROM_STAGE,killPivot);
		}
	}
}