﻿package 
{

	import flash.events.MouseEvent;
	import flash.events.Event;
	import flash.events.IOErrorEvent;
	import flash.events.SecurityErrorEvent;
	import flash.display.Sprite;
	import flash.display.Graphics;
	import flash.display.LineScaleMode;
	import flash.display.JointStyle;
	import flash.display.CapsStyle;
	import flash.geom.Point;
	import flash.display.Stage;
	
	import com.greensock.TweenLite;
	import com.cartogrammar.drawing.CubicBezier;
    import com.greensock.dataTransfer.XMLManager;
	import com.manolis.utils.DataExtract;
	import com.manolis.display.geometry.*;
	

	public class graffiti_playback2 extends Sprite
	{
		private var myManager:XMLManager;
		private var xyt:Array              = new Array();
		private var secs:Number            = new Number(0);
		private var millisecs:Number       = new Number(0);
		private var tag:Sprite             = new Sprite();
		private var backgrnd:Rect;
		private var k:uint                 = new uint(0);
		private var l1:Array               = new Array();
		private var l2:Array               = new Array();
		private var markerWeight:Number    = new Number();
		private var markerColor:uint       = new uint(0);
		private var lineC:uint             = new Number(); 
		private var loop:Boolean           = new Boolean(true);
		
		public function graffiti_playback2():void
		{
            

			if (stage)
			{
				init();
			}
			else
			{
				addEventListener(Event.ADDED_TO_STAGE,init,false,0,true);
			}
		}
		
		private function init(e:Event=null):void
		{
			removeEventListener(Event.ADDED_TO_STAGE,init);
			
			loaderInfo.addEventListener(Event.COMPLETE, gmlPathLoaded, false, 0, true);
			
		}
		
		// FLASHVARS HAVE LOADED
		
		private function gmlPathLoaded(e:Event):void
		{
			// PASSING VARIABLES FROM HTML
			
			var gml:String       = e.target.parameters.gmlPath;  
            var backgroundC:uint = e.target.parameters.bC;
			markerWeight         = e.target.parameters.markerWeight;
			markerColor          = e.target.parameters.markerColor;
			lineC                = e.target.parameters.lC;
			if(e.target.parameters.loop == "true") loop = true; 
			else loop = false ;
			
			// CREATING BACKGROUND
			
			backgrnd = new Rect(stage.stageWidth, stage.stageHeight, 0, "TOP_LEFT", backgroundC);
			addChild(backgrnd);
			
			// Initialize the XML LOADER AND PARSER
			
			myManager = new XMLManager();
			myManager.addEventListener(Event.COMPLETE, onComplete, false, 0, true);
			myManager.addEventListener(IOErrorEvent.IO_ERROR, onError, false, 0, true);
			myManager.addEventListener(SecurityErrorEvent.SECURITY_ERROR, onError, false, 0, true);
			myManager.load(gml);
			
			// REMOVE EVENT LISTENER
			loaderInfo.removeEventListener(Event.COMPLETE, gmlPathLoaded);
			
		}
		
		// XML LOADER EVENT HANDLERS
		private function onComplete(event:Event):void
		{

			var newCoor:Array;
			
			var pO:Object  = event.target.parsedObject.tag[0].drawing[0].stroke[0].pt;
			
			// EXTRACT COORDINATES AND COPY THEM INTO AN ARRAY, THE STAGE DIMENSIONS ARE NEEDED TO SIZE THE TAG
			xyt = DataExtract.xyzArray(pO, stage.stageWidth, stage.stageHeight);
			
			/*
			//  xyt IS A MULTIDIMENSIONAL ARRAY THAT CONTAINS IN THE X XOORDINATES xyt[0],
			//  THE Y COORDINATES xyt[1] AND THE TIME xyt[2]
			*/
			
			// CALCULATE NEW COORDINATES FOR TOP LINE l1 AND BOTTOM LINE l2
			
			newCoor        = DataExtract.calculateNewCoor(xyt[0], xyt[1], markerWeight);
			l1             = newCoor[0];
			l2             = newCoor[1];
			
			//  ADD TAG SPRITE WHERE THE TAG WILL BE DRAWN
			addChild(tag);
			tag.cacheAsBitmap = true;
			
			renderTag();
			
			//  REMOVE LISTENERS
			
			myManager.removeEventListener(Event.COMPLETE, onComplete);
			myManager.removeEventListener(IOErrorEvent.IO_ERROR, onError);
			myManager.removeEventListener(SecurityErrorEvent.SECURITY_ERROR, onError);
		}
		
		private function onError(event:Event):void
		{
			
			trace("ERROR loading XML.");
			
		}
		private function renderTag():void
		{
			// CLEAR THE GRAPHICS IF ANY AND CHANGE ALPHA TO 1
				
		    tag.graphics.clear();
			tag.alpha = 1;
		    
			// RESET COUNTER
				
			k = 0;
			
			// START DRAWING
			
			addEventListener(Event.ENTER_FRAME, onEF, false, 0, true);
		
		}
		
		private function onEF(e:Event)
		{
			/*
			//  THREE POINT ARE ALWAYS NEEDED FOR EACH ARCH, TWO POINT WILL DRAW A STRAIGHT LINE
			*/
			
			//  TOP ARCH COORDINATES
			
			var p1a:Point = l1[k];
			var p2a:Point = l1[k+1];
			var p3a:Point = l1[k+2];
			
			
			//  BOTTOM ARCH COORDINATES
			
			var p1b:Point = l2[k];
			var p2b:Point = l2[k+1];
			var p3b:Point = l2[k+2];
			
			with(tag.graphics)
			{
				//START FILL AND ASSIGN A LINESTYLE
				
				beginFill(markerColor);
			    lineStyle(1, lineC, 1.0, true, LineScaleMode.NORMAL, CapsStyle.ROUND, JointStyle.ROUND);
				
				// MOVE TO STARTING POINT
			    
				moveTo(p1a.x, p1a.y);
				
				// DRAW TOP ARCH
			    
				CubicBezier.curveThroughPoints(tag.graphics, new Array(p1a, p2a, p3a), .5, .75, false);
				
				// REMOVE THE STYLE SO NO CAP APPERS WHEN CONNECTING THE TOP ARCH TO THE BOTTOM ARCH
			    
				lineStyle();
			    
				// MOVE TO START OF SECOND ARCH
				
				lineTo(p3b.x, p3b.y);
				
				// CHANGE THE LINESTYLE OF THE BOTTOM ARCH
			    
				lineStyle(1, lineC, 1.0, true, LineScaleMode.NORMAL, CapsStyle.ROUND, JointStyle.ROUND);
				
				// DRAW BOTTOM ARCH
			    
				CubicBezier.curveThroughPoints(tag.graphics, new Array(p3b, p2b, p1b), .5, .75, false);
			    
				// REMOVE LINESTYLE
				
				lineStyle();
			
			    // MOVE LINE TO THE STARTING POINT
			    
				lineTo(p1a.x, p1a.y);
				
				// END FILL
			    
				endFill();
			}
			
			// UPDATE COUNTER 
			
			k += 2;
			
			// KILL ON ENTER FRAME WHEN THE TAG HAS REACHED THE END OF THE xy ARRAY
			
			if(l1.length - 2 <= k)
			{
				
				removeEventListener(Event.ENTER_FRAME, onEF);
				
				// FADE TAG OUT, ON COMPLETE RESTART TAG
				
				if(loop) TweenLite.to(tag, 1, {delay: 2, alpha:0, onComplete:renderTag});
				
				
			}
			
		}
		
	}
}