#ifndef GRAFMANAGER_H
#define GRAFMANAGER_H

#include "ofMain.h"
#include "grafTag.h"
#include "grafRecorder.h"
#include "grafVStroke.h"
#include "grafVParticleField.h"
#include "grafIO.h"
//#include "guiManager.h"
#include "ofxXmlSettings.h"
#include "pocoDirectoryLister.h"
#include "ofxControlPanel.h"


enum{ MODE_NORM, MODE_TRANS, MODE_REC };


class grafManager 
{
    public:
        grafManager();
        virtual ~grafManager();

        void setup();

        // clears all 
        void reset();

        // updates recording, animation and transitions
        void update();
		bool updateTransitions( grafTag * tag, float dt );
		void updateRotation(grafTag * tag);
		void updateGui();
	
        // draws current visuals to screen
        void draw();
		void drawPlayback();
		void drawRecording();
		
		// loading content (bUseFolders should be true is files are all in sub folders of same name)
		void loadTag( string filename );
		void loadAllSavedTags( string directory, bool bUseFolders = true );
	
	
		// tag management
		void resetTag();
		void nextTag();
		void prevTag();
		void adjustTagPos( int x, int y, int z );
		void adjustTagRot( int x, int y );
	
		// gui setup and control
		void setupGuiControls();
		
		// saving and loading
		void loadAllSavedFiles();
	
		// interface
		ofxControlPanel			panel;
		bool					bPanelOn;
	
		// input and output
		grafIO					* io;
		ofxPocoDirectoryLister  * pocoLister;                   // searches through directories
		vector<string>			dirs;
	
		// recording and smoothingç
		grafRecorder			* recorder;				// records a tag
		grafCurveSmoother		* smoother;		


        // tags
		vector<grafTag>         myTags;					// vector of all loaded or recorded tags
	
		
		// visuals
		grafVStroke				* vizStroke;			// object to calculate and draw a thick stroked line
		grafVParticleField		* vizParticleField;		// particle field visuals
		
		// transition params
		float avgRate;
		float fadeRate;
	
	
		float	screenW, screenH;
		float	recScale;
		int		currentTag;
		float	rotation;
		
	
		// time data
		float                   waitTime;				// time (in seconds) to wait before playing transition to next tag
		float                   waitCounter;			// counter to countdown wait time
		float                   lastTime;				// last time of render , for time based animatoin
		float                   dt;						// time difference from last frame
		
		ofTrueTypeFont			franklinBook;
		ofTrueTypeFont			franklinBookSM;
		ofTrueTypeFont			franklinBookSSM;
	
		
	
    protected:

		// storage and data handling
		void storeCurrentRecording();
	
		// states
		bool bPlaying;
		bool bReadyToRecord;
		int	 mode;
		int nRecordings;


    private:
};

#endif // GRAFMANAGER_H
