#ifndef GRAFREC_H
#define GRAFREC_H

#include "ofMain.h"
#include "grafTag.h"
#include "grafCurveSmoother.h"

#define MAX_REC_PTS		20000

class grafRecorder
{
    public:
        grafRecorder();
        virtual ~grafRecorder();


		void setScale( float val ){ scale = val; }
	
		// clears all
        void clear();

        // update
        void update(float x, float y);
	
		// recording
		void startRecording( float rotation );
		void stopRecording();
		void smooth( grafTag * tag );
	
		// draw
		void draw(int hScreenW, int hScreenH );
		
		// get
		bool isRecording(){ return bRecording; }
	
		
		
		// 
		grafCurveSmoother	smoother;
		
		// tag to hold current recording tag
		grafTag tag;
	
		// scale to convert points 0 to 1
		float scale;
		
		// initial rotation when drawing starts
		float iniRotation;
	
	
    protected:
		
		// states
		bool bRecording;
	
		// vertex arrays
		float	pos[MAX_REC_PTS][3];
	
	

    private:
};

#endif // GRAFTAG_H
