#include "grafVStroke.h"

grafVStroke::grafVStroke()
{
    reset();
    bSwap				= false;
    sclLineSlim			= 0.03f;
    sclLineFat			= 0.025f;
    strokeBaseAlpha		= .95f;
    strokeBaseVal		= 1.f;
    outlineBaseVal		= 0.f;
    outlineBaseThick	= 1.f;
    bUseSlimMode		= true;
	alpha				= 1.f;

}

grafVStroke::~grafVStroke()
{
    //dtor
}

void grafVStroke::reset()
{
    alphaWireFrame      = 0;
    alphaStroke         = 1;
    alphaStrokeOutline  = 1;
    fadeLineWidth       = 1;
	alpha				= 1;

    leftPts.clear();
    rightPts.clear();

    leftPtsInv.clear();
    rightPtsInv.clear();

    distSlim.clear();
}

void grafVStroke::draw(grafTag * PR, int hScreenW, int hScreenH)
{
    if( PR->pts.size() == 0 ) return;

    // draw fat lines!
	glPushMatrix();
	
		glTranslatef(hScreenW, hScreenH, 0);
		glScalef(PR->drawScale,PR->drawScale,1);
	
		drawTimeStroke(PR);
	
	glPopMatrix();
	

}

void grafVStroke::drawWireframe( grafTag * PR )
{
   /* glColor4f(0,0,0, .1*alphaWireFrame);

    glBegin(GL_LINE_STRIP);
    for (int i = 1; i < PR->pts.size()-1; i++)
    {
        glVertex3f( PR->pts[i].pos.x, PR->pts[i].pos.y, .51 + (1000*PR->pts[i].time) / PR->z_const );
    }
    glEnd();*/


}

void grafVStroke::calculateStroke(grafTag * PR)
{
    if(leftPts.size() > 0 ) return;

    //cout << "calc storke " << endl;
	
	// reset swap so it always starts false
    bSwap = false;

    // clear points
    leftPts.clear();
    rightPts.clear();

    leftPtsInv.clear();
    rightPtsInv.clear();

    distSlim.clear();

    float lastZ = 0;//-PR->pts[PR->getNumPts()-1].pos.z;
	//cout << lastZ << endl;
	
	// calculate the zero point
    calculatePoint(PR->pts[0], lastZ+PR->pts[0].pos.z, 0, 0, leftPts, rightPts);
    calculatePoint(PR->pts[0], lastZ+PR->pts[0].pos.z, 0, 0, leftPtsInv, rightPtsInv);

    distSlim.push_back(0);
    
	// calc rest
    int nPts = PR->pts.size();
	
	for (int i = 1; i < PR->getNumPts(); i++)
    {
        float dist      = sclLineFat * (PR->pts[i].dist/PR->distMax);
        float angle     = PR->pts[i].angle;
        float time_num  = lastZ + PR->pts[i].pos.z;
		
        float deltaA = fabs( PR->pts[i].angle - PR->pts[i-1].angle );
        if( deltaA > (HALF_PI) && TWO_PI-deltaA > HALF_PI ) bSwap = !bSwap;

        float pct  = 1;
        float diff = 1;

        if( i < 5 ) pct		= i / 4.f;
        if( i < 5 ) diff	= powf( pct,1.1f );

        if( i > PR->pts.size()-5 ) pct  =  (nPts-i) / 4.f;
        if( i > PR->pts.size()-5 ) diff = powf( pct,1.1);

        if( bSwap ) calculatePoint( PR->pts[i], time_num, dist*diff, angle, leftPts, rightPts );
        else        calculatePoint( PR->pts[i], time_num, dist*diff, angle, rightPts, leftPts );

        diff = 0;
        if( i > nPts-5 ) pct =  ( i-( nPts-6 ) ) / 4.f;
        if( i > nPts-5)  diff = (PR->distMax-PR->pts[i].dist) * powf( pct,1.1);

        if( i < 10 ) pct = i / 9.f;
        if( i < 10 ) diff = ( PR->distMax - PR->pts[i].dist ) * powf( 1-pct,1.10);

        dist = sclLineSlim - (sclLineSlim * (( (PR->pts[i].dist+diff )/PR->distMax)) );
        dist *= fadeLineWidth;
        distSlim.push_back( 1.2* ( 1 - (PR->pts[i].dist/PR->distMax) ) );

        if( bSwap ) calculatePoint(PR->pts[i], time_num, dist, angle, rightPtsInv, leftPtsInv);
        else        calculatePoint(PR->pts[i], time_num, dist, angle, leftPtsInv, rightPtsInv);

    }
	
	// average stroke down a bit 
	averagePoints(.25);
}

float grafVStroke::getAlphaForLinePosition( int pos, int total )
{
    float pct = 1;

    int min = 10;
    int max = total - min;

    if (pos < min ) pct = pos / (float) (min-1);
    if (pos > max ) pct = 1 - ( ( pos-max )  / (float) (min-1) );

    return pct;
}

void grafVStroke::calculatePoint(timePt pt, float time_num, float dist, float angle, vector<ofPoint>&left, vector<ofPoint>&right)
{
    // limit min dist
    dist = MAX(dist,.005);

    float left_x,left_y,right_x,right_y;

    left_x 	= pt.pos.x-(sin(pt.angle)*dist);
    left_y 	= pt.pos.y+(cos(pt.angle)*dist);
    right_x = pt.pos.x+(sin(pt.angle)*dist);
    right_y = pt.pos.y-(cos(pt.angle)*dist);


    left.push_back( ofPoint(left_x,left_y,time_num) );
    right.push_back( ofPoint(right_x,right_y,time_num) );
}

void grafVStroke::drawFatLine(grafTag * PR, vector<ofPoint>&left,vector<ofPoint>&right, float grayVal, float alpha, bool bUseDrawShape, bool bUseLines)
{

    int numToDraw = PR->getCurrentId()-(PR->getStartPt()+1);

    if( numToDraw <= 0 ) return;

		
	glEnableClientState(GL_VERTEX_ARRAY);
    glEnableClientState(GL_COLOR_ARRAY);

    
	
	float gVal = grayVal*alphaStroke;
	float nPts = PR->pts.size();
	
	for(int i = 1; i < PR->getCurrentId(); i++)
    {

        if(PR->getCurrentId() > right.size()-1) continue;

        float color[4*4];
		float points[3*4];
		//memset(color,1,(4*4)*sizeof(float));
		
		int		ar  = 0;
		int		cr  = 0;
		
		float	distS = MAX( alpha, distSlim[i-1] );
        float	pctb  = distS * getAlphaForLinePosition( i-1,nPts );

        // add prev point
        points[ar]   = left[i-1].x;
        points[++ar] = left[i-1].y;
        points[++ar] = left[i-1].z;
        color[cr]	 = gVal;
		color[++cr]  = gVal;
		color[++cr]  = gVal;
		color[++cr]  = pctb*alphaStroke;

        points[++ar] = right[i-1].x;
        points[++ar] = right[i-1].y;
        points[++ar] = right[i-1].z;
        color[++cr] = gVal;
		color[++cr] = gVal;
		color[++cr] = gVal;
		color[++cr] = pctb*alphaStroke;
		
        distS		= MAX(alpha, distSlim[i]);
        float pct	= distS * getAlphaForLinePosition( i,nPts );

        // add prev point
        points[++ar] = right[i].x;
        points[++ar] = right[i].y;
        points[++ar] = right[i].z;
		color[++cr]  = gVal;
		color[++cr]  = gVal;
		color[++cr]  = gVal;
		color[++cr]  = pct*alphaStroke;

        points[++ar]  = left[i].x;
        points[++ar]  = left[i].y;
        points[++ar]  = left[i].z;
		color[++cr]  = gVal;
		color[++cr]  = gVal;
		color[++cr]  = gVal;
		color[++cr]  = pct*alphaStroke;

        glVertexPointer(3, GL_FLOAT, 0, points);
		glColorPointer( 4, GL_FLOAT, 0, color);
		
		glDrawArrays(GL_TRIANGLE_FAN, 0, 4);
		
    }

	// last interpolated point
	vector<ofPoint> rightLast;
	vector<ofPoint> leftLast;
	
	timePt pt;
	pt.pos		= PR->getCurrentPoint();
	pt.angle	= PR->getCurrentAngle();
	pt.dist		= PR->getCurrentPoint().z;
	
	calculatePoint(pt, PR->getCurrentPoint().z, PR->getCurrentDist(), PR->getCurrentAngle(), leftLast, rightLast);
	float	distS = MAX( alpha, distSlim[nPts-1] );
	float	pctb  = distS * getAlphaForLinePosition( nPts-1,nPts );
	
	float color[4*4];
	float points[3*4];
	
	int ar = 0;
	int cr = 0;
	
	points[ar]   = left[nPts-1].x;
	points[++ar] = left[nPts-1].y;
	points[++ar] = left[nPts-1].z;
	color[cr]	 = gVal;
	color[++cr]  = gVal;
	color[++cr]  = gVal;
	color[++cr]  = pctb*alphaStroke;
	
	points[++ar] = right[nPts-1].x;
	points[++ar] = right[nPts-1].y;
	points[++ar] = right[nPts-1].z;
	color[++cr]	 = gVal;
	color[++cr]  = gVal;
	color[++cr]  = gVal;
	color[++cr]  = pctb*alphaStroke;
	
	distS		= MAX(alpha, distSlim[nPts-1]);
	float pct	= distS * getAlphaForLinePosition( nPts-1,nPts );
	
	// add prev point
	points[++ar] = rightLast[0].x;
	points[++ar] = rightLast[0].y;
	points[++ar] = rightLast[0].z;
	color[++cr]	 = gVal;
	color[++cr]  = gVal;
	color[++cr]  = gVal;
	color[++cr]  = pct*alphaStroke;
	
	points[++ar] = leftLast[0].x;
	points[++ar] = leftLast[0].y;
	points[++ar] = leftLast[0].z;
	color[++cr]	 = gVal;
	color[++cr]  = gVal;
	color[++cr]  = gVal;
	color[++cr]  = pct*alphaStroke;
	
	glVertexPointer(3, GL_FLOAT, 0, points);
	glColorPointer(4, GL_FLOAT, 0, color);
	
	glDrawArrays(GL_TRIANGLE_FAN, 0, 4);
	
	
	glDisableClientState(GL_VERTEX_ARRAY);
    glDisableClientState(GL_COLOR_ARRAY);



}

void grafVStroke::drawTimeStroke( grafTag * PR )
{


        // make line calculations
    calculateStroke(PR);
	

    glEnable(GL_DEPTH_TEST);
    ofFill();

    if(bUseSlimMode)
    {
        // draw line so that the slower the stroke, the fatter the line
        drawFatLine(PR,leftPtsInv,rightPtsInv, strokeBaseVal, strokeBaseAlpha, false);
        drawFatOutline(PR,leftPtsInv,rightPtsInv);
    }else{

        drawFatLine(PR,leftPts,rightPts, strokeBaseVal, strokeBaseAlpha, false);
        drawFatOutline(PR,leftPts,rightPts);
    }

    glDisable(GL_DEPTH_TEST);

}

void grafVStroke::drawFatOutline(grafTag * PR, vector<ofPoint>&left,vector<ofPoint>&right)
{
    float linePoints[6];

    glLineWidth(outlineBaseThick);
    glColor4f(outlineBaseVal,outlineBaseVal,outlineBaseVal,1);

	glEnableClientState(GL_VERTEX_ARRAY);
	
	for( int i=0; i<PR->getCurrentId(); i++)
    {
        linePoints[0] = left[i-1].x;
        linePoints[1] = left[i-1].y;
        linePoints[2] = left[i-1].z+.1;

        linePoints[3] = left[i].x;
        linePoints[4] = left[i].y;
        linePoints[5] = left[i].z+.1;

        float pct = getAlphaForLinePosition(i,PR->pts.size());
        glColor4f(outlineBaseVal,outlineBaseVal,outlineBaseVal,.9*alphaStroke*powf(pct,1.5));

        
        glVertexPointer(3, GL_FLOAT, 0, &linePoints[0]);
        glDrawArrays(GL_LINES, 0, 2);

    }

    for( int i=1; i<PR->getCurrentId(); i++)
    {
        linePoints[0] = right[i-1].x;
        linePoints[1] = right[i-1].y;
        linePoints[2] = right[i-1].z+.1;

        linePoints[3] = right[i].x;
        linePoints[4] = right[i].y;
        linePoints[5] = right[i].z+.1;

        float pct = getAlphaForLinePosition(i,PR->pts.size());
        glColor4f(outlineBaseVal,outlineBaseVal,outlineBaseVal,.9*alphaStroke*powf(pct,1.5));

        glVertexPointer(3, GL_FLOAT, 0, &linePoints[0]);
        glDrawArrays(GL_LINES, 0, 2);

    }

	glDisableClientState(GL_VERTEX_ARRAY);

    glLineWidth(1.f);
}

void grafVStroke::alterParam( float val, float & param )
{
    param += val;
    param = MIN( MAX(param,0), 1 );
}

void grafVStroke::drawTimeLine( grafTag * PR )
{
}

void grafVStroke::averagePoints(float pct)
{
    float pctSis = (1-pct) * .5f;

    for( int i = 2; i < leftPtsInv.size(); i++)
    {
        leftPtsInv[i-1].x = (pctSis * leftPtsInv[i-2].x) + (pct * leftPtsInv[i-1].x) + (pctSis * leftPtsInv[i].x);
        leftPtsInv[i-1].y = (pctSis * leftPtsInv[i-2].y) + (pct * leftPtsInv[i-1].y) + (pctSis * leftPtsInv[i].y);
    }


    for( int i = 2; i < rightPtsInv.size(); i++)
    {
        rightPtsInv[i-1].x = (pctSis * rightPtsInv[i-2].x) + (pct * rightPtsInv[i-1].x) + (pctSis * rightPtsInv[i].x);
        rightPtsInv[i-1].y = (pctSis * rightPtsInv[i-2].y) + (pct * rightPtsInv[i-1].y) + (pctSis * rightPtsInv[i].y);
    }
}
