#ifndef GUIMANAGER_H
#define GUIMANAGER_H

#include "guiSlider.h"
#include "guiButton.h"
#include "guiButtonGroup.h"
#include "guiDoubleButton.h"
#include "guiScroller.h"
#include "ofxXmlSettings.h"

class guiManager
{
    public:
        guiManager();
        virtual ~guiManager();

        void draw();

        void addSlider( string name, float defVal, float min, float max, float x, float y, float w, float h);
        void addButton( string name, float x, float y, float w, float h, bool bOnOff, int val=-1, int drawMode = DRAW_NORM);
		void addDoubleButton( string name, float x, float y, float w, float h, bool bOnOff, int val = -1, int drawMode = DRAW_NORM);
		void addScroller( string name, int x, int y, int w, int h, int font_size, bool bVertical = true );
		void addToScrollList( string scrollerName, vector<string> names);
		void addToScrollList( string scrollerName, string name);
        
		bool updateDrag( float mx, float my );
        bool updatePress( float mx, float my );
		bool updatePressDoubleTap( float mx, float my );
		void update(float dt = .1f);

        float	getFloatVal( string name );
        int		getIntVal( string name );
        float	getPctVal( string name );
        bool	getButtonVal( string name );
		bool	getButtonHitTest( string name, int x, int y );
	
		void setButton(  string name, bool val );
		void setDoubleButton(  string name, int clicks );

        void saveDataToXML();
        void loadDataFromXML();

        vector<guiSlider> sliders;
        vector<guiButton> buttons;
		vector<guiDoubleButton> dbuttons;
		vector<guiScroller> scrollers;

    protected:
    private:
};

#endif // GUIMANAGER_H
