#include "guiScroller.h"

guiScroller::guiScroller()
{
    vel = 0.f;
    damp = .99f;
    bVertical = true;
}

guiScroller::~guiScroller()
{
    //dtor
}

void guiScroller::setup(  string myName, int x, int y, int w, int h, int font_size, bool bV )
{
    scrollBox.setup(x,y,w,h);

    fontsize = font_size;
    buttonH = fontsize*2;

    frabk.loadFont("frabk.ttf",fontsize);

    bVertical = bV;
	
	name = myName;
}

void guiScroller::addToList(string name)
{
    files.push_back(name);

    guiButton tempButton;
    buttons.push_back(tempButton);

	
    if(bVertical)
        buttons[buttons.size()-1].setup( name, scrollBox.getX(), scrollBox.getY() + buttonH*(buttons.size()-1),  scrollBox.getW(), buttonH,false, 200 );
    else
        buttons[buttons.size()-1].setup( name, scrollBox.getX() + buttonH*(buttons.size()-1),scrollBox.getY(),  buttonH,scrollBox.getH(),false, 200 );

}

void guiScroller::update( float dt )
{

    if(buttons.size() == 0 ) return;

    // check if hit top
    if( bVertical ){
        if( vel < 0 && buttons[buttons.size()-1].getY() < (scrollBox.getY()+scrollBox.getH() - buttonH) )
            vel = 0;
        else if( vel > 0 && buttons[0].getY() >= scrollBox.getY())
            vel = 0;
    }else{
        if( vel < 0 && buttons[buttons.size()-1].getX() < (scrollBox.getX()+scrollBox.getW() - buttonH) )
            vel = 0;
        else if( vel > 0 && buttons[0].getX() >= scrollBox.getX())
            vel = 0;
    }



    for( int i = 0; i < buttons.size(); i++)
    {
        if( bVertical ) buttons[i].hitBox.y += vel;
        else buttons[i].hitBox.x += vel;
    }

    vel -= (vel*damp*dt);
}

void guiScroller::scroll( float v )
{
    vel += v;
}

void guiScroller::draw()
{
    int fH = frabk.stringHeight("HELLO");

    ofSetColor(255,255,255);

    for( int i = 0; i < buttons.size(); i++)
    {
        if( bVertical )
        {
            if( buttons[i].getY() < (scrollBox.getY()+scrollBox.getH() - buttonH) && buttons[i].getY() >= scrollBox.getY() )
            {
                frabk.drawString( files[i], buttons[i].getX()+4,buttons[i].getY()+fH);
                buttons[i].draw();
            }
        }else{

			if( buttons[i].getX() < (scrollBox.getX()+scrollBox.getW() - buttonH) && buttons[i].getX() >= scrollBox.getX() )
            {
                //float strW = .5*buttons[i].getH();
				float strH = .5*buttons[i].getW();
                glPushMatrix();
                    glRotatef(-90,0,0,1);
                    glTranslatef(-strH/2,0,0);
					frabk.drawString( files[i],-scrollBox.getY()-buttons[i].getH()+8,buttons[i].getX()+fH);///*-buttons[i].getH()+4*/,buttons[i].getX()+fH);//buttons[i].getY(),buttons[i].getX());
				glPopMatrix();
                
				buttons[i].draw();
            }
        }


    }

    scrollBox.draw();
}
