#include "recordingApp.h"


//--------------------------------------------------------------
recordingApp::recordingApp(){

    camW    = 320;
    camH    = 240;
    camId   = 1;
    screenW = ofGetWidth();
    screenH = ofGetHeight();
    bUseVideoFiles = false;
    bShowInfo = false;
	bShowCVPanel = true;
	zoom = 0;
	bZooming = true;

}

//--------------------------------------------------------------
void recordingApp::reset()
{
	PR->clear();
}
//--------------------------------------------------------------
void recordingApp::setup(){



	//-----------
	panel.setup("cv", 330, 0, 300, 220);
	panel.addPanel("cv settings", 1, false);
	panel.addPanel("camera settings", 1, false);
	
	panel.setWhichPanel("cv settings");
	panel.addSlider("Threshold","THRESHOLD",180,0,255,true);
	
	panel.setWhichPanel("camera settings");
	panel.addSlider("Cam Id (restart)","CAM_ID",0,0,10,true);
	panel.addToggle("Flip X", "FLIP_X", false);
	panel.addToggle("Flip Y", "FLIP_Y", false);
	
	panel.loadSettings("settings/cv-settings.xml");
	
	loadConfigSettings( "settings/config.xml" );
	
	camId = panel.getValueI("CAM_ID");

    //----------- video settings
	if (bUseVideoFiles == true){

		videoSource			= new ofVideoPlayer();
		((ofVideoPlayer *)videoSource)->loadMovie("fingers.mov");
		((ofVideoPlayer *)videoSource)->play();
		((ofVideoPlayer *)videoSource)->setLoopState(OF_LOOP_NORMAL);
		((ofVideoPlayer *)videoSource)->setSpeed(1);

	} else {

		videoSource			= new ofVideoGrabber();
		//((ofVideoGrabber *)videoSource)->setVerbose(true);
		((ofVideoGrabber *)videoSource)->listDevices();
		((ofVideoGrabber *)videoSource)->setDeviceID(camId);
		((ofVideoGrabber *)videoSource)->initGrabber(camW, camH);
		//((ofVideoGrabber *)videoSource)->listDevices();
	}

    //----------- tracking setup
    TR = new tracker();
    TR->setup(camW,camH);
    TR->loadFromXML("trackingConfig.xml");

    //----------- "mouse" recording
	PR = new gRecorder();
    PR->setup(camW,camH);

    //----------- editing
    GE = new grafEditor();
    GE->setup(20,screenH-80,200,18);

    //----------- saving data
    DM = new grafIO();

	//----------- app setup
	lastX           = 0;
	lastY           = 0;
	mouse_mode      = 3;


    PR->rotation.set(0,0,0);
    PR->position.set(0,0,1);

    bUseMouseCapture = false;
    bShowCVPanel     = true;
	bShiftOn         = false;
	bShowEditPanel   = false;


    //-----------
    ofSetFrameRate(60);
    ofBackground(0.0f, 0.0f, 0.0f);
	
	

	

}

//--------------------------------------------------------------
void recordingApp::update(){

    screenW = ofGetWidth();
    screenH = ofGetHeight();

    ofBackground(0,0,0);

    //----------- video capture
    videoSource->update();


    //-----------
    if(!bUseMouseCapture) TR->update( videoSource->getPixels() );


	//-----------
    ofPoint addPoint;
    if(bUseMouseCapture)    addPoint.set(lastX,lastY,1 );
    else                    addPoint.set(TR->getX(), TR->getY(),1);


   if(PR->bAmRecording)  PR->update(addPoint);
	if(PR->bAmRecording) GE->updateMax( PR->getNumPts()-1 );
	else
		PR->resetForEditing();
	
	//cout << "name button" << GE->button_name.bOn << endl;
	panel.update();
	TR->threshold = panel.getValueI("THRESHOLD");
	TR->bFlipV = panel.getValueB("FLIP_Y");
	TR->bFlipH = panel.getValueB("FLIP_X");
	
	if(!bShowEditPanel && bZooming && PR->getNumPts() > 0 ) zoom = -(PR->pts[PR->pts.size()-1].time*1000) / PR->z_const;
	else if( bShowEditPanel )
	{
		int halfPt = PR->getStartPt() + (PR->getEndPt() - PR->getStartPt())/2.f;
		zoom = -(PR->pts[halfPt].time*1000) / PR->z_const;
	}
	
}


//--------------------------------------------------------------
void recordingApp::draw(){

    ofNoFill();
	
	
	glEnable(GL_DEPTH_TEST);
	
    //-----------  render
    glPushMatrix();

        glTranslatef(screenW/2, screenH/2, 0);

        glScalef(PR->position.z,PR->position.z,PR->position.z);

        glRotatef(PR->rotation.x,0,1,0);
        glRotatef(PR->rotation.y,1,0,0);
        glRotatef(PR->rotation.z,0,0,1);

		glTranslatef(PR->position.x,PR->position.y,zoom);//PR->position.z);


        glPushMatrix();

            glTranslatef(-screenW/2, -screenH/2, 0);
            glScalef(screenW,screenW,1);

            ofSetColor(255,255,255);
            PR->draw(screenW);

        glPopMatrix();

        ofSetColor(255,0,0);
        glPushMatrix();
            glTranslatef(-screenW/2, -screenH/2, 0);
            glTranslatef(0,0,PR->getCurentZDepth() );
            ofCircle( (TR->getX()/camW) * screenW, (TR->getY()/camW)*screenW, 4 );
		glPopMatrix();

    glPopMatrix();

    //------ controls
	glDisable(GL_DEPTH_TEST);
	
	ofFill();
	ofEnableAlphaBlending();
	ofSetColor(0,0,0,200);
	ofRect(0,ofGetHeight()-90,ofGetWidth(), ofGetHeight());
	
	ofSetColor(0xffffff);
	
	if(bShowCVPanel)
    {
		
		// tracking panels
		TR->draw();
		
		// control panel
		panel.draw();
				
		ofSetColor(0xffffff);
		ofDrawBitmapString( ofToString( ofGetFrameRate(), 2 ),20,500);
		ofDrawBitmapString( "Name: " + GE->getName(),20,520);
		ofDrawBitmapString( "Total Points: " + ofToString(PR->getNumPts()),20,540);
		ofDrawBitmapString( "' ': toggle recording ",20,570);
		ofDrawBitmapString( "c: toggle camera/cv panel ",20,590);
		ofDrawBitmapString( "e: toggle edit panel ",20,610);
		ofDrawBitmapString( "h: toggle info panel ",20,630);
	}
	
	if( bShowEditPanel )
	{
		
		GE->draw();
		
	}
	
	
}


//--------------------------------------------------------------
void recordingApp::keyPressed  (int key){


   

    switch(key){

  		case 'b':
            TR->bCaptureBg = true;
            break;
        case 'c':
            bShowCVPanel = !bShowCVPanel;
            break;
        case 'e':
            bShowEditPanel = !bShowEditPanel;
            PR->toggleEditing(bShowEditPanel);
            break;
        case 'h': bShowInfo = !bShowInfo; break;
        case ' ':
  			break;
  		case '1':
  			//FRONT ELEVATION
  			PR->rotation.set(0.0,0.0,0.0);
  			break;
  		case '2':
  			//SIDE ELEVATION
  			PR->rotation.set(90.0,0.0,0.0);
  			break;
  		case '3':
  			//TOP ELEVATION
  			PR->rotation.set(180.0,90.0,0.0);
  			break;
  		case 's':
  			PR->resetForEditing();
  			GE->checkNameForSaving();
  			//DM->saveGrafTag(GE->getName(),PR);
  			break;
  		case 'p':
            PR->togglePaused();
            break;
        case 'm':
            bUseMouseCapture = !bUseMouseCapture;
            if(bUseMouseCapture){ PR->width = screenW; PR->height = screenH; }
            else{ PR->width = camW; PR->height = camH; }
        default:
  			break;

  }



}

//--------------------------------------------------------------
void recordingApp::keyReleased(int key){

}

//--------------------------------------------------------------
void recordingApp::mouseMoved(int x, int y ){

	lastX   = x;
	lastY   = y;
}

//--------------------------------------------------------------
void recordingApp::mouseDragged(int x, int y, int button){

	if(bShowCVPanel)
	{
	    TR->mouseDragged(x,y,button);
    }

    bool bEdit = false;
    if( bShowEditPanel )
    {
        bEdit = GE->update(x,y) ;
        if ( bEdit )
        {
        PR->setEndPt( GE->getEnd());
        PR->setStartPt( GE->getStart());
        PR->resetForEditing();
        }
    }


    if(!bShowCVPanel && !bEdit)
	{
	    if( button == 0 )
	    {
            if( bShiftOn )
            {
                PR->rotation.x += x - lastX;
                PR->rotation.y += y - lastY;
            }else{

                PR->position.x += x-lastX;
                PR->position.y += y-lastY;
            }

        }else{
            PR->position.z += (y - lastY) * .01f;
        }

	}







	lastX   = x;
	lastY   = y;
	
	panel.mouseDragged(x, y, button);

}

//--------------------------------------------------------------
void recordingApp::mousePressed(int x, int y, int button){

    lastX = x;
	lastY = y;

	if(glutGetModifiers() == GLUT_ACTIVE_SHIFT) bShiftOn = true;

    if(bShowCVPanel) TR->mousePressed(x,y,button);
    if(bShowEditPanel) GE->update(x,y) ;
	
	panel.mousePressed(x, y, button);
	
}

//--------------------------------------------------------------
void recordingApp::mouseReleased(int x, int y, int button){

    bShiftOn = false;
	panel.mouseReleased();

}

//--------------------------------------------------------------
void recordingApp::loadConfigSettings(string filename)
{
    ofxXmlSettings  xml;

    xml.loadFile(filename);

    bUseVideoFiles = xml.getValue("useVideo",false);
    camW    = xml.getValue("camWidth",320);
    camH    = xml.getValue("camHeight",240);
    camId   = xml.getValue("camId",0);

}